<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AmountBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AmountBase
 * @subpackage Structs
 */
class AmountBase extends ApiObject
{
    /**
     * The MilesAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MilesAmount;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalAmount;
    /**
     * Constructor method for AmountBase
     * @uses AmountBase::setMilesAmount()
     * @uses AmountBase::setTotalAmount()
     * @param int $milesAmount
     * @param float $totalAmount
     */
    public function __construct($milesAmount = null, $totalAmount = null)
    {
        $this
            ->setMilesAmount($milesAmount)
            ->setTotalAmount($totalAmount);
    }
    /**
     * Get MilesAmount value
     * @return int|null
     */
    public function getMilesAmount()
    {
        return $this->MilesAmount;
    }
    /**
     * Set MilesAmount value
     * @param int $milesAmount
     * @return \App|C\StructType\AmountBase
     */
    public function setMilesAmount($milesAmount = null)
    {
        // validation for constraint: int
        if (!is_null($milesAmount) && !(is_int($milesAmount) || ctype_digit($milesAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($milesAmount, true), gettype($milesAmount)), __LINE__);
        }
        $this->MilesAmount = $milesAmount;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return float|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param float $totalAmount
     * @return \App|C\StructType\AmountBase
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\AmountBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
