<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValueCodeProperty StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValueCodeProperty
 * @subpackage Structs
 */
class ValueCodeProperty extends ApiObject
{
    /**
     * The BooleanValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $BooleanValue;
    /**
     * The DateTimeValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTimeValue;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NumberValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $NumberValue;
    /**
     * The StringValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringValue;
    /**
     * Constructor method for ValueCodeProperty
     * @uses ValueCodeProperty::setBooleanValue()
     * @uses ValueCodeProperty::setDateTimeValue()
     * @uses ValueCodeProperty::setName()
     * @uses ValueCodeProperty::setNumberValue()
     * @uses ValueCodeProperty::setStringValue()
     * @param bool $booleanValue
     * @param string $dateTimeValue
     * @param string $name
     * @param float $numberValue
     * @param string $stringValue
     */
    public function __construct($booleanValue = null, $dateTimeValue = null, $name = null, $numberValue = null, $stringValue = null)
    {
        $this
            ->setBooleanValue($booleanValue)
            ->setDateTimeValue($dateTimeValue)
            ->setName($name)
            ->setNumberValue($numberValue)
            ->setStringValue($stringValue);
    }
    /**
     * Get BooleanValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getBooleanValue()
    {
        return isset($this->BooleanValue) ? $this->BooleanValue : null;
    }
    /**
     * Set BooleanValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $booleanValue
     * @return \App|C\StructType\ValueCodeProperty
     */
    public function setBooleanValue($booleanValue = null)
    {
        // validation for constraint: boolean
        if (!is_null($booleanValue) && !is_bool($booleanValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($booleanValue, true), gettype($booleanValue)), __LINE__);
        }
        if (is_null($booleanValue) || (is_array($booleanValue) && empty($booleanValue))) {
            unset($this->BooleanValue);
        } else {
            $this->BooleanValue = $booleanValue;
        }
        return $this;
    }
    /**
     * Get DateTimeValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTimeValue()
    {
        return isset($this->DateTimeValue) ? $this->DateTimeValue : null;
    }
    /**
     * Set DateTimeValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTimeValue
     * @return \App|C\StructType\ValueCodeProperty
     */
    public function setDateTimeValue($dateTimeValue = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeValue) && !is_string($dateTimeValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeValue, true), gettype($dateTimeValue)), __LINE__);
        }
        if (is_null($dateTimeValue) || (is_array($dateTimeValue) && empty($dateTimeValue))) {
            unset($this->DateTimeValue);
        } else {
            $this->DateTimeValue = $dateTimeValue;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \App|C\StructType\ValueCodeProperty
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NumberValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getNumberValue()
    {
        return isset($this->NumberValue) ? $this->NumberValue : null;
    }
    /**
     * Set NumberValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $numberValue
     * @return \App|C\StructType\ValueCodeProperty
     */
    public function setNumberValue($numberValue = null)
    {
        // validation for constraint: float
        if (!is_null($numberValue) && !(is_float($numberValue) || is_numeric($numberValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($numberValue, true), gettype($numberValue)), __LINE__);
        }
        if (is_null($numberValue) || (is_array($numberValue) && empty($numberValue))) {
            unset($this->NumberValue);
        } else {
            $this->NumberValue = $numberValue;
        }
        return $this;
    }
    /**
     * Get StringValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringValue()
    {
        return isset($this->StringValue) ? $this->StringValue : null;
    }
    /**
     * Set StringValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringValue
     * @return \App|C\StructType\ValueCodeProperty
     */
    public function setStringValue($stringValue = null)
    {
        // validation for constraint: string
        if (!is_null($stringValue) && !is_string($stringValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringValue, true), gettype($stringValue)), __LINE__);
        }
        if (is_null($stringValue) || (is_array($stringValue) && empty($stringValue))) {
            unset($this->StringValue);
        } else {
            $this->StringValue = $stringValue;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\ValueCodeProperty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
