<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatMap StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatMap
 * @subpackage Structs
 */
class SeatMap extends ApiObject
{
    /**
     * The AircraftName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AircraftName;
    /**
     * The Decks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfSeatDeck
     */
    public $Decks;
    /**
     * The RefSegment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefSegment;
    /**
     * Constructor method for SeatMap
     * @uses SeatMap::setAircraftName()
     * @uses SeatMap::setDecks()
     * @uses SeatMap::setRefSegment()
     * @param string $aircraftName
     * @param \App|C\ArrayType\ArrayOfSeatDeck $decks
     * @param string $refSegment
     */
    public function __construct($aircraftName = null, \App|C\ArrayType\ArrayOfSeatDeck $decks = null, $refSegment = null)
    {
        $this
            ->setAircraftName($aircraftName)
            ->setDecks($decks)
            ->setRefSegment($refSegment);
    }
    /**
     * Get AircraftName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAircraftName()
    {
        return isset($this->AircraftName) ? $this->AircraftName : null;
    }
    /**
     * Set AircraftName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aircraftName
     * @return \App|C\StructType\SeatMap
     */
    public function setAircraftName($aircraftName = null)
    {
        // validation for constraint: string
        if (!is_null($aircraftName) && !is_string($aircraftName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aircraftName, true), gettype($aircraftName)), __LINE__);
        }
        if (is_null($aircraftName) || (is_array($aircraftName) && empty($aircraftName))) {
            unset($this->AircraftName);
        } else {
            $this->AircraftName = $aircraftName;
        }
        return $this;
    }
    /**
     * Get Decks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfSeatDeck|null
     */
    public function getDecks()
    {
        return isset($this->Decks) ? $this->Decks : null;
    }
    /**
     * Set Decks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfSeatDeck $decks
     * @return \App|C\StructType\SeatMap
     */
    public function setDecks(\App|C\ArrayType\ArrayOfSeatDeck $decks = null)
    {
        if (is_null($decks) || (is_array($decks) && empty($decks))) {
            unset($this->Decks);
        } else {
            $this->Decks = $decks;
        }
        return $this;
    }
    /**
     * Get RefSegment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefSegment()
    {
        return isset($this->RefSegment) ? $this->RefSegment : null;
    }
    /**
     * Set RefSegment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refSegment
     * @return \App|C\StructType\SeatMap
     */
    public function setRefSegment($refSegment = null)
    {
        // validation for constraint: string
        if (!is_null($refSegment) && !is_string($refSegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refSegment, true), gettype($refSegment)), __LINE__);
        }
        if (is_null($refSegment) || (is_array($refSegment) && empty($refSegment))) {
            unset($this->RefSegment);
        } else {
            $this->RefSegment = $refSegment;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\SeatMap
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
