<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormOfPaymentSecureCardInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FormOfPaymentSecureCardInfo
 * @subpackage Structs
 */
class FormOfPaymentSecureCardInfo extends ApiObject
{
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The CardTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardTypeCode;
    /**
     * The Crypto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Crypto;
    /**
     * The OwnerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerName;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionNumber;
    /**
     * Constructor method for FormOfPaymentSecureCardInfo
     * @uses FormOfPaymentSecureCardInfo::setCardNumber()
     * @uses FormOfPaymentSecureCardInfo::setCardTypeCode()
     * @uses FormOfPaymentSecureCardInfo::setCrypto()
     * @uses FormOfPaymentSecureCardInfo::setOwnerName()
     * @uses FormOfPaymentSecureCardInfo::setTransactionNumber()
     * @param string $cardNumber
     * @param string $cardTypeCode
     * @param string $crypto
     * @param string $ownerName
     * @param string $transactionNumber
     */
    public function __construct($cardNumber = null, $cardTypeCode = null, $crypto = null, $ownerName = null, $transactionNumber = null)
    {
        $this
            ->setCardNumber($cardNumber)
            ->setCardTypeCode($cardTypeCode)
            ->setCrypto($crypto)
            ->setOwnerName($ownerName)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \App|C\StructType\FormOfPaymentSecureCardInfo
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get CardTypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardTypeCode()
    {
        return isset($this->CardTypeCode) ? $this->CardTypeCode : null;
    }
    /**
     * Set CardTypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardTypeCode
     * @return \App|C\StructType\FormOfPaymentSecureCardInfo
     */
    public function setCardTypeCode($cardTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardTypeCode) && !is_string($cardTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardTypeCode, true), gettype($cardTypeCode)), __LINE__);
        }
        if (is_null($cardTypeCode) || (is_array($cardTypeCode) && empty($cardTypeCode))) {
            unset($this->CardTypeCode);
        } else {
            $this->CardTypeCode = $cardTypeCode;
        }
        return $this;
    }
    /**
     * Get Crypto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrypto()
    {
        return isset($this->Crypto) ? $this->Crypto : null;
    }
    /**
     * Set Crypto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crypto
     * @return \App|C\StructType\FormOfPaymentSecureCardInfo
     */
    public function setCrypto($crypto = null)
    {
        // validation for constraint: string
        if (!is_null($crypto) && !is_string($crypto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crypto, true), gettype($crypto)), __LINE__);
        }
        if (is_null($crypto) || (is_array($crypto) && empty($crypto))) {
            unset($this->Crypto);
        } else {
            $this->Crypto = $crypto;
        }
        return $this;
    }
    /**
     * Get OwnerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerName()
    {
        return isset($this->OwnerName) ? $this->OwnerName : null;
    }
    /**
     * Set OwnerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerName
     * @return \App|C\StructType\FormOfPaymentSecureCardInfo
     */
    public function setOwnerName($ownerName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerName) && !is_string($ownerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerName, true), gettype($ownerName)), __LINE__);
        }
        if (is_null($ownerName) || (is_array($ownerName) && empty($ownerName))) {
            unset($this->OwnerName);
        } else {
            $this->OwnerName = $ownerName;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionNumber
     * @return \App|C\StructType\FormOfPaymentSecureCardInfo
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNumber) && !is_string($transactionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\FormOfPaymentSecureCardInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
