<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Verification StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Verification
 * @subpackage Structs
 */
class Verification extends ApiObject
{
    /**
     * The PassengerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PassengerName;
    /**
     * The RefCustomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefCustomer;
    /**
     * Constructor method for Verification
     * @uses Verification::setPassengerName()
     * @uses Verification::setRefCustomer()
     * @param string $passengerName
     * @param string $refCustomer
     */
    public function __construct($passengerName = null, $refCustomer = null)
    {
        $this
            ->setPassengerName($passengerName)
            ->setRefCustomer($refCustomer);
    }
    /**
     * Get PassengerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassengerName()
    {
        return isset($this->PassengerName) ? $this->PassengerName : null;
    }
    /**
     * Set PassengerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $passengerName
     * @return \App|C\StructType\Verification
     */
    public function setPassengerName($passengerName = null)
    {
        // validation for constraint: string
        if (!is_null($passengerName) && !is_string($passengerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passengerName, true), gettype($passengerName)), __LINE__);
        }
        if (is_null($passengerName) || (is_array($passengerName) && empty($passengerName))) {
            unset($this->PassengerName);
        } else {
            $this->PassengerName = $passengerName;
        }
        return $this;
    }
    /**
     * Get RefCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefCustomer()
    {
        return isset($this->RefCustomer) ? $this->RefCustomer : null;
    }
    /**
     * Set RefCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refCustomer
     * @return \App|C\StructType\Verification
     */
    public function setRefCustomer($refCustomer = null)
    {
        // validation for constraint: string
        if (!is_null($refCustomer) && !is_string($refCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refCustomer, true), gettype($refCustomer)), __LINE__);
        }
        if (is_null($refCustomer) || (is_array($refCustomer) && empty($refCustomer))) {
            unset($this->RefCustomer);
        } else {
            $this->RefCustomer = $refCustomer;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\Verification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
