<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatDeck StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatDeck
 * @subpackage Structs
 */
class SeatDeck extends ApiObject
{
    /**
     * The Areas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfSeatArea
     */
    public $Areas;
    /**
     * The DeckNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DeckNumber;
    /**
     * Constructor method for SeatDeck
     * @uses SeatDeck::setAreas()
     * @uses SeatDeck::setDeckNumber()
     * @param \App|C\ArrayType\ArrayOfSeatArea $areas
     * @param int $deckNumber
     */
    public function __construct(\App|C\ArrayType\ArrayOfSeatArea $areas = null, $deckNumber = null)
    {
        $this
            ->setAreas($areas)
            ->setDeckNumber($deckNumber);
    }
    /**
     * Get Areas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfSeatArea|null
     */
    public function getAreas()
    {
        return isset($this->Areas) ? $this->Areas : null;
    }
    /**
     * Set Areas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfSeatArea $areas
     * @return \App|C\StructType\SeatDeck
     */
    public function setAreas(\App|C\ArrayType\ArrayOfSeatArea $areas = null)
    {
        if (is_null($areas) || (is_array($areas) && empty($areas))) {
            unset($this->Areas);
        } else {
            $this->Areas = $areas;
        }
        return $this;
    }
    /**
     * Get DeckNumber value
     * @return int|null
     */
    public function getDeckNumber()
    {
        return $this->DeckNumber;
    }
    /**
     * Set DeckNumber value
     * @param int $deckNumber
     * @return \App|C\StructType\SeatDeck
     */
    public function setDeckNumber($deckNumber = null)
    {
        // validation for constraint: int
        if (!is_null($deckNumber) && !(is_int($deckNumber) || ctype_digit($deckNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deckNumber, true), gettype($deckNumber)), __LINE__);
        }
        $this->DeckNumber = $deckNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\SeatDeck
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
