<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginDestinationFare StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OriginDestinationFare
 * @subpackage Structs
 */
class OriginDestinationFare extends ApiObject
{
    /**
     * The CouponFares
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfETCouponFare
     */
    public $CouponFares;
    /**
     * The IsAddonFare
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAddonFare;
    /**
     * The OriginDestinationOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OriginDestinationOrder;
    /**
     * The RefWebClass
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefWebClass;
    /**
     * Constructor method for OriginDestinationFare
     * @uses OriginDestinationFare::setCouponFares()
     * @uses OriginDestinationFare::setIsAddonFare()
     * @uses OriginDestinationFare::setOriginDestinationOrder()
     * @uses OriginDestinationFare::setRefWebClass()
     * @param \App|C\ArrayType\ArrayOfETCouponFare $couponFares
     * @param bool $isAddonFare
     * @param int $originDestinationOrder
     * @param string $refWebClass
     */
    public function __construct(\App|C\ArrayType\ArrayOfETCouponFare $couponFares = null, $isAddonFare = null, $originDestinationOrder = null, $refWebClass = null)
    {
        $this
            ->setCouponFares($couponFares)
            ->setIsAddonFare($isAddonFare)
            ->setOriginDestinationOrder($originDestinationOrder)
            ->setRefWebClass($refWebClass);
    }
    /**
     * Get CouponFares value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfETCouponFare|null
     */
    public function getCouponFares()
    {
        return isset($this->CouponFares) ? $this->CouponFares : null;
    }
    /**
     * Set CouponFares value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfETCouponFare $couponFares
     * @return \App|C\StructType\OriginDestinationFare
     */
    public function setCouponFares(\App|C\ArrayType\ArrayOfETCouponFare $couponFares = null)
    {
        if (is_null($couponFares) || (is_array($couponFares) && empty($couponFares))) {
            unset($this->CouponFares);
        } else {
            $this->CouponFares = $couponFares;
        }
        return $this;
    }
    /**
     * Get IsAddonFare value
     * @return bool|null
     */
    public function getIsAddonFare()
    {
        return $this->IsAddonFare;
    }
    /**
     * Set IsAddonFare value
     * @param bool $isAddonFare
     * @return \App|C\StructType\OriginDestinationFare
     */
    public function setIsAddonFare($isAddonFare = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAddonFare) && !is_bool($isAddonFare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAddonFare, true), gettype($isAddonFare)), __LINE__);
        }
        $this->IsAddonFare = $isAddonFare;
        return $this;
    }
    /**
     * Get OriginDestinationOrder value
     * @return int|null
     */
    public function getOriginDestinationOrder()
    {
        return $this->OriginDestinationOrder;
    }
    /**
     * Set OriginDestinationOrder value
     * @param int $originDestinationOrder
     * @return \App|C\StructType\OriginDestinationFare
     */
    public function setOriginDestinationOrder($originDestinationOrder = null)
    {
        // validation for constraint: int
        if (!is_null($originDestinationOrder) && !(is_int($originDestinationOrder) || ctype_digit($originDestinationOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originDestinationOrder, true), gettype($originDestinationOrder)), __LINE__);
        }
        $this->OriginDestinationOrder = $originDestinationOrder;
        return $this;
    }
    /**
     * Get RefWebClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefWebClass()
    {
        return isset($this->RefWebClass) ? $this->RefWebClass : null;
    }
    /**
     * Set RefWebClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refWebClass
     * @return \App|C\StructType\OriginDestinationFare
     */
    public function setRefWebClass($refWebClass = null)
    {
        // validation for constraint: string
        if (!is_null($refWebClass) && !is_string($refWebClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refWebClass, true), gettype($refWebClass)), __LINE__);
        }
        if (is_null($refWebClass) || (is_array($refWebClass) && empty($refWebClass))) {
            unset($this->RefWebClass);
        } else {
            $this->RefWebClass = $refWebClass;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\OriginDestinationFare
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
