<?php

namespace App|C\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Preload ServiceType
 * @subpackage Services
 */
class Preload extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Preload
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\Preload $parameters
     * @return \App|C\StructType\PreloadResponse|bool
     */
    public function Preload(\App|C\StructType\Preload $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Preload($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App|C\StructType\PreloadResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
