<?php

namespace App|C\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSeat ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfSeat
 * @subpackage Arrays
 */
class ArrayOfSeat extends AbstractStructArrayBase
{
    /**
     * The Seat
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\Seat[]
     */
    public $Seat;
    /**
     * Constructor method for ArrayOfSeat
     * @uses ArrayOfSeat::setSeat()
     * @param \App|C\StructType\Seat[] $seat
     */
    public function __construct(array $seat = array())
    {
        $this
            ->setSeat($seat);
    }
    /**
     * Get Seat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\Seat[]|null
     */
    public function getSeat()
    {
        return isset($this->Seat) ? $this->Seat : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSeat method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeat method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatForArrayConstraintsFromSetSeat(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSeatSeatItem) {
            // validation for constraint: itemType
            if (!$arrayOfSeatSeatItem instanceof \App|C\StructType\Seat) {
                $invalidValues[] = is_object($arrayOfSeatSeatItem) ? get_class($arrayOfSeatSeatItem) : sprintf('%s(%s)', gettype($arrayOfSeatSeatItem), var_export($arrayOfSeatSeatItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Seat property can only contain items of type \App|C\StructType\Seat, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Seat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App|C\StructType\Seat[] $seat
     * @return \App|C\ArrayType\ArrayOfSeat
     */
    public function setSeat(array $seat = array())
    {
        // validation for constraint: array
        if ('' !== ($seatArrayErrorMessage = self::validateSeatForArrayConstraintsFromSetSeat($seat))) {
            throw new \InvalidArgumentException($seatArrayErrorMessage, __LINE__);
        }
        if (is_null($seat) || (is_array($seat) && empty($seat))) {
            unset($this->Seat);
        } else {
            $this->Seat = $seat;
        }
        return $this;
    }
    /**
     * Add item to Seat value
     * @throws \InvalidArgumentException
     * @param \App|C\StructType\Seat $item
     * @return \App|C\ArrayType\ArrayOfSeat
     */
    public function addToSeat(\App|C\StructType\Seat $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App|C\StructType\Seat) {
            throw new \InvalidArgumentException(sprintf('The Seat property can only contain items of type \App|C\StructType\Seat, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Seat[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \App|C\StructType\Seat|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \App|C\StructType\Seat|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \App|C\StructType\Seat|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \App|C\StructType\Seat|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \App|C\StructType\Seat|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Seat
     */
    public function getAttributeName()
    {
        return 'Seat';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\ArrayType\ArrayOfSeat
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
