<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebClassFilter StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebClassFilter
 * @subpackage Structs
 */
class WebClassFilter extends AbstractStructBase
{
    /**
     * The FilterName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FilterName;
    /**
     * The IsMandatory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsMandatory;
    /**
     * The WebClasses
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfValueCode
     */
    public $WebClasses;
    /**
     * Constructor method for WebClassFilter
     * @uses WebClassFilter::setFilterName()
     * @uses WebClassFilter::setIsMandatory()
     * @uses WebClassFilter::setWebClasses()
     * @param string $filterName
     * @param bool $isMandatory
     * @param \App|C\ArrayType\ArrayOfValueCode $webClasses
     */
    public function __construct($filterName = null, $isMandatory = null, \App|C\ArrayType\ArrayOfValueCode $webClasses = null)
    {
        $this
            ->setFilterName($filterName)
            ->setIsMandatory($isMandatory)
            ->setWebClasses($webClasses);
    }
    /**
     * Get FilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFilterName()
    {
        return isset($this->FilterName) ? $this->FilterName : null;
    }
    /**
     * Set FilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $filterName
     * @return \App|C\StructType\WebClassFilter
     */
    public function setFilterName($filterName = null)
    {
        // validation for constraint: string
        if (!is_null($filterName) && !is_string($filterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filterName, true), gettype($filterName)), __LINE__);
        }
        if (is_null($filterName) || (is_array($filterName) && empty($filterName))) {
            unset($this->FilterName);
        } else {
            $this->FilterName = $filterName;
        }
        return $this;
    }
    /**
     * Get IsMandatory value
     * @return bool|null
     */
    public function getIsMandatory()
    {
        return $this->IsMandatory;
    }
    /**
     * Set IsMandatory value
     * @param bool $isMandatory
     * @return \App|C\StructType\WebClassFilter
     */
    public function setIsMandatory($isMandatory = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMandatory) && !is_bool($isMandatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMandatory, true), gettype($isMandatory)), __LINE__);
        }
        $this->IsMandatory = $isMandatory;
        return $this;
    }
    /**
     * Get WebClasses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfValueCode|null
     */
    public function getWebClasses()
    {
        return isset($this->WebClasses) ? $this->WebClasses : null;
    }
    /**
     * Set WebClasses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfValueCode $webClasses
     * @return \App|C\StructType\WebClassFilter
     */
    public function setWebClasses(\App|C\ArrayType\ArrayOfValueCode $webClasses = null)
    {
        if (is_null($webClasses) || (is_array($webClasses) && empty($webClasses))) {
            unset($this->WebClasses);
        } else {
            $this->WebClasses = $webClasses;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\WebClassFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
