<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValueCode StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValueCode
 * @subpackage Structs
 */
class ValueCode extends ApiObject
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The Label
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Label;
    /**
     * The ValueCodeProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfValueCodeProperty
     */
    public $ValueCodeProperties;
    /**
     * Constructor method for ValueCode
     * @uses ValueCode::setCode()
     * @uses ValueCode::setLabel()
     * @uses ValueCode::setValueCodeProperties()
     * @param string $code
     * @param string $label
     * @param \App|C\ArrayType\ArrayOfValueCodeProperty $valueCodeProperties
     */
    public function __construct($code = null, $label = null, \App|C\ArrayType\ArrayOfValueCodeProperty $valueCodeProperties = null)
    {
        $this
            ->setCode($code)
            ->setLabel($label)
            ->setValueCodeProperties($valueCodeProperties);
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \App|C\StructType\ValueCode
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get Label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabel()
    {
        return isset($this->Label) ? $this->Label : null;
    }
    /**
     * Set Label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $label
     * @return \App|C\StructType\ValueCode
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        if (is_null($label) || (is_array($label) && empty($label))) {
            unset($this->Label);
        } else {
            $this->Label = $label;
        }
        return $this;
    }
    /**
     * Get ValueCodeProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfValueCodeProperty|null
     */
    public function getValueCodeProperties()
    {
        return isset($this->ValueCodeProperties) ? $this->ValueCodeProperties : null;
    }
    /**
     * Set ValueCodeProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfValueCodeProperty $valueCodeProperties
     * @return \App|C\StructType\ValueCode
     */
    public function setValueCodeProperties(\App|C\ArrayType\ArrayOfValueCodeProperty $valueCodeProperties = null)
    {
        if (is_null($valueCodeProperties) || (is_array($valueCodeProperties) && empty($valueCodeProperties))) {
            unset($this->ValueCodeProperties);
        } else {
            $this->ValueCodeProperties = $valueCodeProperties;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\ValueCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
