<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Amount StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Amount
 * @subpackage Structs
 */
class Amount extends AmountSummary
{
    /**
     * The DiscountAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DiscountAmount;
    /**
     * Constructor method for Amount
     * @uses Amount::setDiscountAmount()
     * @param float $discountAmount
     */
    public function __construct($discountAmount = null)
    {
        $this
            ->setDiscountAmount($discountAmount);
    }
    /**
     * Get DiscountAmount value
     * @return float|null
     */
    public function getDiscountAmount()
    {
        return $this->DiscountAmount;
    }
    /**
     * Set DiscountAmount value
     * @param float $discountAmount
     * @return \App|C\StructType\Amount
     */
    public function setDiscountAmount($discountAmount = null)
    {
        // validation for constraint: float
        if (!is_null($discountAmount) && !(is_float($discountAmount) || is_numeric($discountAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountAmount, true), gettype($discountAmount)), __LINE__);
        }
        $this->DiscountAmount = $discountAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\Amount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
