<?php

namespace App|C\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPenalty ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPenalty
 * @subpackage Arrays
 */
class ArrayOfPenalty extends AbstractStructArrayBase
{
    /**
     * The Penalty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\Penalty[]
     */
    public $Penalty;
    /**
     * Constructor method for ArrayOfPenalty
     * @uses ArrayOfPenalty::setPenalty()
     * @param \App|C\StructType\Penalty[] $penalty
     */
    public function __construct(array $penalty = array())
    {
        $this
            ->setPenalty($penalty);
    }
    /**
     * Get Penalty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\Penalty[]|null
     */
    public function getPenalty()
    {
        return isset($this->Penalty) ? $this->Penalty : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPenalty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPenalty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePenaltyForArrayConstraintsFromSetPenalty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPenaltyPenaltyItem) {
            // validation for constraint: itemType
            if (!$arrayOfPenaltyPenaltyItem instanceof \App|C\StructType\Penalty) {
                $invalidValues[] = is_object($arrayOfPenaltyPenaltyItem) ? get_class($arrayOfPenaltyPenaltyItem) : sprintf('%s(%s)', gettype($arrayOfPenaltyPenaltyItem), var_export($arrayOfPenaltyPenaltyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Penalty property can only contain items of type \App|C\StructType\Penalty, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Penalty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App|C\StructType\Penalty[] $penalty
     * @return \App|C\ArrayType\ArrayOfPenalty
     */
    public function setPenalty(array $penalty = array())
    {
        // validation for constraint: array
        if ('' !== ($penaltyArrayErrorMessage = self::validatePenaltyForArrayConstraintsFromSetPenalty($penalty))) {
            throw new \InvalidArgumentException($penaltyArrayErrorMessage, __LINE__);
        }
        if (is_null($penalty) || (is_array($penalty) && empty($penalty))) {
            unset($this->Penalty);
        } else {
            $this->Penalty = $penalty;
        }
        return $this;
    }
    /**
     * Add item to Penalty value
     * @throws \InvalidArgumentException
     * @param \App|C\StructType\Penalty $item
     * @return \App|C\ArrayType\ArrayOfPenalty
     */
    public function addToPenalty(\App|C\StructType\Penalty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App|C\StructType\Penalty) {
            throw new \InvalidArgumentException(sprintf('The Penalty property can only contain items of type \App|C\StructType\Penalty, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Penalty[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \App|C\StructType\Penalty|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \App|C\StructType\Penalty|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \App|C\StructType\Penalty|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \App|C\StructType\Penalty|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \App|C\StructType\Penalty|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Penalty
     */
    public function getAttributeName()
    {
        return 'Penalty';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\ArrayType\ArrayOfPenalty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
