<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ETTicketDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ETTicketDetails
 * @subpackage Structs
 */
class ETTicketDetails extends ApiObject
{
    /**
     * The IFTIssuanceInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\IFTIssuanceInfo
     */
    public $IFTIssuanceInfo;
    /**
     * The ORGIssuanceInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\ORGIssuanceInfo
     */
    public $ORGIssuanceInfo;
    /**
     * Constructor method for ETTicketDetails
     * @uses ETTicketDetails::setIFTIssuanceInfo()
     * @uses ETTicketDetails::setORGIssuanceInfo()
     * @param \App|C\StructType\IFTIssuanceInfo $iFTIssuanceInfo
     * @param \App|C\StructType\ORGIssuanceInfo $oRGIssuanceInfo
     */
    public function __construct(\App|C\StructType\IFTIssuanceInfo $iFTIssuanceInfo = null, \App|C\StructType\ORGIssuanceInfo $oRGIssuanceInfo = null)
    {
        $this
            ->setIFTIssuanceInfo($iFTIssuanceInfo)
            ->setORGIssuanceInfo($oRGIssuanceInfo);
    }
    /**
     * Get IFTIssuanceInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\IFTIssuanceInfo|null
     */
    public function getIFTIssuanceInfo()
    {
        return isset($this->IFTIssuanceInfo) ? $this->IFTIssuanceInfo : null;
    }
    /**
     * Set IFTIssuanceInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\IFTIssuanceInfo $iFTIssuanceInfo
     * @return \App|C\StructType\ETTicketDetails
     */
    public function setIFTIssuanceInfo(\App|C\StructType\IFTIssuanceInfo $iFTIssuanceInfo = null)
    {
        if (is_null($iFTIssuanceInfo) || (is_array($iFTIssuanceInfo) && empty($iFTIssuanceInfo))) {
            unset($this->IFTIssuanceInfo);
        } else {
            $this->IFTIssuanceInfo = $iFTIssuanceInfo;
        }
        return $this;
    }
    /**
     * Get ORGIssuanceInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\ORGIssuanceInfo|null
     */
    public function getORGIssuanceInfo()
    {
        return isset($this->ORGIssuanceInfo) ? $this->ORGIssuanceInfo : null;
    }
    /**
     * Set ORGIssuanceInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\ORGIssuanceInfo $oRGIssuanceInfo
     * @return \App|C\StructType\ETTicketDetails
     */
    public function setORGIssuanceInfo(\App|C\StructType\ORGIssuanceInfo $oRGIssuanceInfo = null)
    {
        if (is_null($oRGIssuanceInfo) || (is_array($oRGIssuanceInfo) && empty($oRGIssuanceInfo))) {
            unset($this->ORGIssuanceInfo);
        } else {
            $this->ORGIssuanceInfo = $oRGIssuanceInfo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\ETTicketDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
