<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EMDTicketIataInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EMDTicketIataInfo
 * @subpackage Structs
 */
class EMDTicketIataInfo extends ApiObject
{
    /**
     * The IsMco
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsMco;
    /**
     * The ReasonCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReasonCode;
    /**
     * The ReasonGroupCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReasonGroupCode;
    /**
     * The ReasonSubCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReasonSubCode;
    /**
     * Constructor method for EMDTicketIataInfo
     * @uses EMDTicketIataInfo::setIsMco()
     * @uses EMDTicketIataInfo::setReasonCode()
     * @uses EMDTicketIataInfo::setReasonGroupCode()
     * @uses EMDTicketIataInfo::setReasonSubCode()
     * @param bool $isMco
     * @param string $reasonCode
     * @param string $reasonGroupCode
     * @param string $reasonSubCode
     */
    public function __construct($isMco = null, $reasonCode = null, $reasonGroupCode = null, $reasonSubCode = null)
    {
        $this
            ->setIsMco($isMco)
            ->setReasonCode($reasonCode)
            ->setReasonGroupCode($reasonGroupCode)
            ->setReasonSubCode($reasonSubCode);
    }
    /**
     * Get IsMco value
     * @return bool|null
     */
    public function getIsMco()
    {
        return $this->IsMco;
    }
    /**
     * Set IsMco value
     * @param bool $isMco
     * @return \App|C\StructType\EMDTicketIataInfo
     */
    public function setIsMco($isMco = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMco) && !is_bool($isMco)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMco, true), gettype($isMco)), __LINE__);
        }
        $this->IsMco = $isMco;
        return $this;
    }
    /**
     * Get ReasonCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReasonCode()
    {
        return isset($this->ReasonCode) ? $this->ReasonCode : null;
    }
    /**
     * Set ReasonCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reasonCode
     * @return \App|C\StructType\EMDTicketIataInfo
     */
    public function setReasonCode($reasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($reasonCode) && !is_string($reasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonCode, true), gettype($reasonCode)), __LINE__);
        }
        if (is_null($reasonCode) || (is_array($reasonCode) && empty($reasonCode))) {
            unset($this->ReasonCode);
        } else {
            $this->ReasonCode = $reasonCode;
        }
        return $this;
    }
    /**
     * Get ReasonGroupCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReasonGroupCode()
    {
        return isset($this->ReasonGroupCode) ? $this->ReasonGroupCode : null;
    }
    /**
     * Set ReasonGroupCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reasonGroupCode
     * @return \App|C\StructType\EMDTicketIataInfo
     */
    public function setReasonGroupCode($reasonGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($reasonGroupCode) && !is_string($reasonGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonGroupCode, true), gettype($reasonGroupCode)), __LINE__);
        }
        if (is_null($reasonGroupCode) || (is_array($reasonGroupCode) && empty($reasonGroupCode))) {
            unset($this->ReasonGroupCode);
        } else {
            $this->ReasonGroupCode = $reasonGroupCode;
        }
        return $this;
    }
    /**
     * Get ReasonSubCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReasonSubCode()
    {
        return isset($this->ReasonSubCode) ? $this->ReasonSubCode : null;
    }
    /**
     * Set ReasonSubCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reasonSubCode
     * @return \App|C\StructType\EMDTicketIataInfo
     */
    public function setReasonSubCode($reasonSubCode = null)
    {
        // validation for constraint: string
        if (!is_null($reasonSubCode) && !is_string($reasonSubCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonSubCode, true), gettype($reasonSubCode)), __LINE__);
        }
        if (is_null($reasonSubCode) || (is_array($reasonSubCode) && empty($reasonSubCode))) {
            unset($this->ReasonSubCode);
        } else {
            $this->ReasonSubCode = $reasonSubCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\EMDTicketIataInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
