<?php

namespace App|C\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Prepare ServiceType
 * @subpackage Services
 */
class Prepare extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PrepareFlights
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\PrepareFlights $parameters
     * @return \App|C\StructType\PrepareFlightsResponse|bool
     */
    public function PrepareFlights(\App|C\StructType\PrepareFlights $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PrepareFlights($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PrepareBookingModification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\PrepareBookingModification $parameters
     * @return \App|C\StructType\PrepareBookingModificationResponse|bool
     */
    public function PrepareBookingModification(\App|C\StructType\PrepareBookingModification $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PrepareBookingModification($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PrepareExchange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\PrepareExchange $parameters
     * @return \App|C\StructType\PrepareExchangeResponse|bool
     */
    public function PrepareExchange(\App|C\StructType\PrepareExchange $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PrepareExchange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PrepareCheckin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\PrepareCheckin $parameters
     * @return \App|C\StructType\PrepareCheckinResponse|bool
     */
    public function PrepareCheckin(\App|C\StructType\PrepareCheckin $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PrepareCheckin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PrepareCancel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\PrepareCancel $parameters
     * @return \App|C\StructType\PrepareCancelResponse|bool
     */
    public function PrepareCancel(\App|C\StructType\PrepareCancel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PrepareCancel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App|C\StructType\PrepareBookingModificationResponse|\App|C\StructType\PrepareCancelResponse|\App|C\StructType\PrepareCheckinResponse|\App|C\StructType\PrepareExchangeResponse|\App|C\StructType\PrepareFlightsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
