<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialServiceReference StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SpecialServiceReference
 * @subpackage Structs
 */
class SpecialServiceReference extends ApiObject
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The RefPassenger
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefPassenger;
    /**
     * The RefSegment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefSegment;
    /**
     * The TechnicalType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TechnicalType;
    /**
     * Constructor method for SpecialServiceReference
     * @uses SpecialServiceReference::setCode()
     * @uses SpecialServiceReference::setRefPassenger()
     * @uses SpecialServiceReference::setRefSegment()
     * @uses SpecialServiceReference::setTechnicalType()
     * @param string $code
     * @param string $refPassenger
     * @param string $refSegment
     * @param string $technicalType
     */
    public function __construct($code = null, $refPassenger = null, $refSegment = null, $technicalType = null)
    {
        $this
            ->setCode($code)
            ->setRefPassenger($refPassenger)
            ->setRefSegment($refSegment)
            ->setTechnicalType($technicalType);
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \App|C\StructType\SpecialServiceReference
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get RefPassenger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefPassenger()
    {
        return isset($this->RefPassenger) ? $this->RefPassenger : null;
    }
    /**
     * Set RefPassenger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refPassenger
     * @return \App|C\StructType\SpecialServiceReference
     */
    public function setRefPassenger($refPassenger = null)
    {
        // validation for constraint: string
        if (!is_null($refPassenger) && !is_string($refPassenger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refPassenger, true), gettype($refPassenger)), __LINE__);
        }
        if (is_null($refPassenger) || (is_array($refPassenger) && empty($refPassenger))) {
            unset($this->RefPassenger);
        } else {
            $this->RefPassenger = $refPassenger;
        }
        return $this;
    }
    /**
     * Get RefSegment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefSegment()
    {
        return isset($this->RefSegment) ? $this->RefSegment : null;
    }
    /**
     * Set RefSegment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refSegment
     * @return \App|C\StructType\SpecialServiceReference
     */
    public function setRefSegment($refSegment = null)
    {
        // validation for constraint: string
        if (!is_null($refSegment) && !is_string($refSegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refSegment, true), gettype($refSegment)), __LINE__);
        }
        if (is_null($refSegment) || (is_array($refSegment) && empty($refSegment))) {
            unset($this->RefSegment);
        } else {
            $this->RefSegment = $refSegment;
        }
        return $this;
    }
    /**
     * Get TechnicalType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTechnicalType()
    {
        return isset($this->TechnicalType) ? $this->TechnicalType : null;
    }
    /**
     * Set TechnicalType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $technicalType
     * @return \App|C\StructType\SpecialServiceReference
     */
    public function setTechnicalType($technicalType = null)
    {
        // validation for constraint: string
        if (!is_null($technicalType) && !is_string($technicalType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($technicalType, true), gettype($technicalType)), __LINE__);
        }
        if (is_null($technicalType) || (is_array($technicalType) && empty($technicalType))) {
            unset($this->TechnicalType);
        } else {
            $this->TechnicalType = $technicalType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\SpecialServiceReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
