<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SegmentBooking StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SegmentBooking
 * @subpackage Structs
 */
class SegmentBooking extends SegmentRef
{
    /**
     * The BookingClass
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\BookingClass
     */
    public $BookingClass;
    /**
     * The TimeLimit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TimeLimit;
    /**
     * Constructor method for SegmentBooking
     * @uses SegmentBooking::setBookingClass()
     * @uses SegmentBooking::setTimeLimit()
     * @param \App|C\StructType\BookingClass $bookingClass
     * @param string $timeLimit
     */
    public function __construct(\App|C\StructType\BookingClass $bookingClass = null, $timeLimit = null)
    {
        $this
            ->setBookingClass($bookingClass)
            ->setTimeLimit($timeLimit);
    }
    /**
     * Get BookingClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\BookingClass|null
     */
    public function getBookingClass()
    {
        return isset($this->BookingClass) ? $this->BookingClass : null;
    }
    /**
     * Set BookingClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\BookingClass $bookingClass
     * @return \App|C\StructType\SegmentBooking
     */
    public function setBookingClass(\App|C\StructType\BookingClass $bookingClass = null)
    {
        if (is_null($bookingClass) || (is_array($bookingClass) && empty($bookingClass))) {
            unset($this->BookingClass);
        } else {
            $this->BookingClass = $bookingClass;
        }
        return $this;
    }
    /**
     * Get TimeLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeLimit()
    {
        return isset($this->TimeLimit) ? $this->TimeLimit : null;
    }
    /**
     * Set TimeLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeLimit
     * @return \App|C\StructType\SegmentBooking
     */
    public function setTimeLimit($timeLimit = null)
    {
        // validation for constraint: string
        if (!is_null($timeLimit) && !is_string($timeLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeLimit, true), gettype($timeLimit)), __LINE__);
        }
        if (is_null($timeLimit) || (is_array($timeLimit) && empty($timeLimit))) {
            unset($this->TimeLimit);
        } else {
            $this->TimeLimit = $timeLimit;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\SegmentBooking
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
