<?php

namespace App|C\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerDocument ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCustomerDocument
 * @subpackage Arrays
 */
class ArrayOfCustomerDocument extends AbstractStructArrayBase
{
    /**
     * The CustomerDocument
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\CustomerDocument[]
     */
    public $CustomerDocument;
    /**
     * Constructor method for ArrayOfCustomerDocument
     * @uses ArrayOfCustomerDocument::setCustomerDocument()
     * @param \App|C\StructType\CustomerDocument[] $customerDocument
     */
    public function __construct(array $customerDocument = array())
    {
        $this
            ->setCustomerDocument($customerDocument);
    }
    /**
     * Get CustomerDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\CustomerDocument[]|null
     */
    public function getCustomerDocument()
    {
        return isset($this->CustomerDocument) ? $this->CustomerDocument : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerDocumentForArrayConstraintsFromSetCustomerDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCustomerDocumentCustomerDocumentItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerDocumentCustomerDocumentItem instanceof \App|C\StructType\CustomerDocument) {
                $invalidValues[] = is_object($arrayOfCustomerDocumentCustomerDocumentItem) ? get_class($arrayOfCustomerDocumentCustomerDocumentItem) : sprintf('%s(%s)', gettype($arrayOfCustomerDocumentCustomerDocumentItem), var_export($arrayOfCustomerDocumentCustomerDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomerDocument property can only contain items of type \App|C\StructType\CustomerDocument, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomerDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App|C\StructType\CustomerDocument[] $customerDocument
     * @return \App|C\ArrayType\ArrayOfCustomerDocument
     */
    public function setCustomerDocument(array $customerDocument = array())
    {
        // validation for constraint: array
        if ('' !== ($customerDocumentArrayErrorMessage = self::validateCustomerDocumentForArrayConstraintsFromSetCustomerDocument($customerDocument))) {
            throw new \InvalidArgumentException($customerDocumentArrayErrorMessage, __LINE__);
        }
        if (is_null($customerDocument) || (is_array($customerDocument) && empty($customerDocument))) {
            unset($this->CustomerDocument);
        } else {
            $this->CustomerDocument = $customerDocument;
        }
        return $this;
    }
    /**
     * Add item to CustomerDocument value
     * @throws \InvalidArgumentException
     * @param \App|C\StructType\CustomerDocument $item
     * @return \App|C\ArrayType\ArrayOfCustomerDocument
     */
    public function addToCustomerDocument(\App|C\StructType\CustomerDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App|C\StructType\CustomerDocument) {
            throw new \InvalidArgumentException(sprintf('The CustomerDocument property can only contain items of type \App|C\StructType\CustomerDocument, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomerDocument[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \App|C\StructType\CustomerDocument|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \App|C\StructType\CustomerDocument|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \App|C\StructType\CustomerDocument|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \App|C\StructType\CustomerDocument|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \App|C\StructType\CustomerDocument|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerDocument
     */
    public function getAttributeName()
    {
        return 'CustomerDocument';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\ArrayType\ArrayOfCustomerDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
