<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerNameRecord StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PassengerNameRecord
 * @subpackage Structs
 */
class PassengerNameRecord extends ApiObject
{
    /**
     * The Passengers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfPassenger
     */
    public $Passengers;
    /**
     * The PnrInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\PassengerNameRecordInformation
     */
    public $PnrInformation;
    /**
     * The SeatMaps
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfSeatMap
     */
    public $SeatMaps;
    /**
     * The Segments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfSegmentBooking
     */
    public $Segments;
    /**
     * The SpecialServices
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfSpecialService
     */
    public $SpecialServices;
    /**
     * Constructor method for PassengerNameRecord
     * @uses PassengerNameRecord::setPassengers()
     * @uses PassengerNameRecord::setPnrInformation()
     * @uses PassengerNameRecord::setSeatMaps()
     * @uses PassengerNameRecord::setSegments()
     * @uses PassengerNameRecord::setSpecialServices()
     * @param \App|C\ArrayType\ArrayOfPassenger $passengers
     * @param \App|C\StructType\PassengerNameRecordInformation $pnrInformation
     * @param \App|C\ArrayType\ArrayOfSeatMap $seatMaps
     * @param \App|C\ArrayType\ArrayOfSegmentBooking $segments
     * @param \App|C\ArrayType\ArrayOfSpecialService $specialServices
     */
    public function __construct(\App|C\ArrayType\ArrayOfPassenger $passengers = null, \App|C\StructType\PassengerNameRecordInformation $pnrInformation = null, \App|C\ArrayType\ArrayOfSeatMap $seatMaps = null, \App|C\ArrayType\ArrayOfSegmentBooking $segments = null, \App|C\ArrayType\ArrayOfSpecialService $specialServices = null)
    {
        $this
            ->setPassengers($passengers)
            ->setPnrInformation($pnrInformation)
            ->setSeatMaps($seatMaps)
            ->setSegments($segments)
            ->setSpecialServices($specialServices);
    }
    /**
     * Get Passengers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfPassenger|null
     */
    public function getPassengers()
    {
        return isset($this->Passengers) ? $this->Passengers : null;
    }
    /**
     * Set Passengers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfPassenger $passengers
     * @return \App|C\StructType\PassengerNameRecord
     */
    public function setPassengers(\App|C\ArrayType\ArrayOfPassenger $passengers = null)
    {
        if (is_null($passengers) || (is_array($passengers) && empty($passengers))) {
            unset($this->Passengers);
        } else {
            $this->Passengers = $passengers;
        }
        return $this;
    }
    /**
     * Get PnrInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\PassengerNameRecordInformation|null
     */
    public function getPnrInformation()
    {
        return isset($this->PnrInformation) ? $this->PnrInformation : null;
    }
    /**
     * Set PnrInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\PassengerNameRecordInformation $pnrInformation
     * @return \App|C\StructType\PassengerNameRecord
     */
    public function setPnrInformation(\App|C\StructType\PassengerNameRecordInformation $pnrInformation = null)
    {
        if (is_null($pnrInformation) || (is_array($pnrInformation) && empty($pnrInformation))) {
            unset($this->PnrInformation);
        } else {
            $this->PnrInformation = $pnrInformation;
        }
        return $this;
    }
    /**
     * Get SeatMaps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfSeatMap|null
     */
    public function getSeatMaps()
    {
        return isset($this->SeatMaps) ? $this->SeatMaps : null;
    }
    /**
     * Set SeatMaps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfSeatMap $seatMaps
     * @return \App|C\StructType\PassengerNameRecord
     */
    public function setSeatMaps(\App|C\ArrayType\ArrayOfSeatMap $seatMaps = null)
    {
        if (is_null($seatMaps) || (is_array($seatMaps) && empty($seatMaps))) {
            unset($this->SeatMaps);
        } else {
            $this->SeatMaps = $seatMaps;
        }
        return $this;
    }
    /**
     * Get Segments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfSegmentBooking|null
     */
    public function getSegments()
    {
        return isset($this->Segments) ? $this->Segments : null;
    }
    /**
     * Set Segments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfSegmentBooking $segments
     * @return \App|C\StructType\PassengerNameRecord
     */
    public function setSegments(\App|C\ArrayType\ArrayOfSegmentBooking $segments = null)
    {
        if (is_null($segments) || (is_array($segments) && empty($segments))) {
            unset($this->Segments);
        } else {
            $this->Segments = $segments;
        }
        return $this;
    }
    /**
     * Get SpecialServices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfSpecialService|null
     */
    public function getSpecialServices()
    {
        return isset($this->SpecialServices) ? $this->SpecialServices : null;
    }
    /**
     * Set SpecialServices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfSpecialService $specialServices
     * @return \App|C\StructType\PassengerNameRecord
     */
    public function setSpecialServices(\App|C\ArrayType\ArrayOfSpecialService $specialServices = null)
    {
        if (is_null($specialServices) || (is_array($specialServices) && empty($specialServices))) {
            unset($this->SpecialServices);
        } else {
            $this->SpecialServices = $specialServices;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\PassengerNameRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
