<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NameElement StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:NameElement
 * @subpackage Structs
 */
class NameElement extends ApiObject
{
    /**
     * The CivilityCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CivilityCode;
    /**
     * The Firstname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Firstname;
    /**
     * The Middlename
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Middlename;
    /**
     * The Surname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Surname;
    /**
     * Constructor method for NameElement
     * @uses NameElement::setCivilityCode()
     * @uses NameElement::setFirstname()
     * @uses NameElement::setMiddlename()
     * @uses NameElement::setSurname()
     * @param string $civilityCode
     * @param string $firstname
     * @param string $middlename
     * @param string $surname
     */
    public function __construct($civilityCode = null, $firstname = null, $middlename = null, $surname = null)
    {
        $this
            ->setCivilityCode($civilityCode)
            ->setFirstname($firstname)
            ->setMiddlename($middlename)
            ->setSurname($surname);
    }
    /**
     * Get CivilityCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCivilityCode()
    {
        return isset($this->CivilityCode) ? $this->CivilityCode : null;
    }
    /**
     * Set CivilityCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $civilityCode
     * @return \App|C\StructType\NameElement
     */
    public function setCivilityCode($civilityCode = null)
    {
        // validation for constraint: string
        if (!is_null($civilityCode) && !is_string($civilityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($civilityCode, true), gettype($civilityCode)), __LINE__);
        }
        if (is_null($civilityCode) || (is_array($civilityCode) && empty($civilityCode))) {
            unset($this->CivilityCode);
        } else {
            $this->CivilityCode = $civilityCode;
        }
        return $this;
    }
    /**
     * Get Firstname value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstname()
    {
        return isset($this->Firstname) ? $this->Firstname : null;
    }
    /**
     * Set Firstname value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstname
     * @return \App|C\StructType\NameElement
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstname, true), gettype($firstname)), __LINE__);
        }
        if (is_null($firstname) || (is_array($firstname) && empty($firstname))) {
            unset($this->Firstname);
        } else {
            $this->Firstname = $firstname;
        }
        return $this;
    }
    /**
     * Get Middlename value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMiddlename()
    {
        return isset($this->Middlename) ? $this->Middlename : null;
    }
    /**
     * Set Middlename value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $middlename
     * @return \App|C\StructType\NameElement
     */
    public function setMiddlename($middlename = null)
    {
        // validation for constraint: string
        if (!is_null($middlename) && !is_string($middlename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middlename, true), gettype($middlename)), __LINE__);
        }
        if (is_null($middlename) || (is_array($middlename) && empty($middlename))) {
            unset($this->Middlename);
        } else {
            $this->Middlename = $middlename;
        }
        return $this;
    }
    /**
     * Get Surname value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSurname()
    {
        return isset($this->Surname) ? $this->Surname : null;
    }
    /**
     * Set Surname value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $surname
     * @return \App|C\StructType\NameElement
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        if (is_null($surname) || (is_array($surname) && empty($surname))) {
            unset($this->Surname);
        } else {
            $this->Surname = $surname;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\NameElement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
