<?php

namespace App|C\EnumType;

/**
 * This class stands for FaultType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:FaultType
 * @subpackage Enumerations
 */
class FaultType
{
    /**
     * Constant for value 'Unexpected'
     * @return string 'Unexpected'
     */
    const VALUE_UNEXPECTED = 'Unexpected';
    /**
     * Constant for value 'Alert'
     * @return string 'Alert'
     */
    const VALUE_ALERT = 'Alert';
    /**
     * Constant for value 'Business'
     * @return string 'Business'
     */
    const VALUE_BUSINESS = 'Business';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNEXPECTED
     * @uses self::VALUE_ALERT
     * @uses self::VALUE_BUSINESS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNEXPECTED,
            self::VALUE_ALERT,
            self::VALUE_BUSINESS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
