<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialServiceDataPassengerType StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SpecialServiceDataPassengerType
 * @subpackage Structs
 */
class SpecialServiceDataPassengerType extends ApiObject
{
    /**
     * The DateOfBirth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DateOfBirth;
    /**
     * The RefPassengerWithSeat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefPassengerWithSeat;
    /**
     * Constructor method for SpecialServiceDataPassengerType
     * @uses SpecialServiceDataPassengerType::setDateOfBirth()
     * @uses SpecialServiceDataPassengerType::setRefPassengerWithSeat()
     * @param string $dateOfBirth
     * @param string $refPassengerWithSeat
     */
    public function __construct($dateOfBirth = null, $refPassengerWithSeat = null)
    {
        $this
            ->setDateOfBirth($dateOfBirth)
            ->setRefPassengerWithSeat($refPassengerWithSeat);
    }
    /**
     * Get DateOfBirth value
     * @return string|null
     */
    public function getDateOfBirth()
    {
        return $this->DateOfBirth;
    }
    /**
     * Set DateOfBirth value
     * @param string $dateOfBirth
     * @return \App|C\StructType\SpecialServiceDataPassengerType
     */
    public function setDateOfBirth($dateOfBirth = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfBirth) && !is_string($dateOfBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfBirth, true), gettype($dateOfBirth)), __LINE__);
        }
        $this->DateOfBirth = $dateOfBirth;
        return $this;
    }
    /**
     * Get RefPassengerWithSeat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefPassengerWithSeat()
    {
        return isset($this->RefPassengerWithSeat) ? $this->RefPassengerWithSeat : null;
    }
    /**
     * Set RefPassengerWithSeat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refPassengerWithSeat
     * @return \App|C\StructType\SpecialServiceDataPassengerType
     */
    public function setRefPassengerWithSeat($refPassengerWithSeat = null)
    {
        // validation for constraint: string
        if (!is_null($refPassengerWithSeat) && !is_string($refPassengerWithSeat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refPassengerWithSeat, true), gettype($refPassengerWithSeat)), __LINE__);
        }
        if (is_null($refPassengerWithSeat) || (is_array($refPassengerWithSeat) && empty($refPassengerWithSeat))) {
            unset($this->RefPassengerWithSeat);
        } else {
            $this->RefPassengerWithSeat = $refPassengerWithSeat;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\SpecialServiceDataPassengerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
