<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrepareFlightsRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PrepareFlightsRequest
 * @subpackage Structs
 */
class PrepareFlightsRequest extends AbstractRequest
{
    /**
     * The DeferredIssuance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DeferredIssuance;
    /**
     * The FareInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\FareInfo
     */
    public $FareInfo;
    /**
     * The Offer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\OfferIn
     */
    public $Offer;
    /**
     * The Passengers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfPassenger
     */
    public $Passengers;
    /**
     * The PromoCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PromoCode;
    /**
     * The Segments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfSegmentBooking
     */
    public $Segments;
    /**
     * Constructor method for PrepareFlightsRequest
     * @uses PrepareFlightsRequest::setDeferredIssuance()
     * @uses PrepareFlightsRequest::setFareInfo()
     * @uses PrepareFlightsRequest::setOffer()
     * @uses PrepareFlightsRequest::setPassengers()
     * @uses PrepareFlightsRequest::setPromoCode()
     * @uses PrepareFlightsRequest::setSegments()
     * @param bool $deferredIssuance
     * @param \App|C\StructType\FareInfo $fareInfo
     * @param \App|C\StructType\OfferIn $offer
     * @param \App|C\ArrayType\ArrayOfPassenger $passengers
     * @param string $promoCode
     * @param \App|C\ArrayType\ArrayOfSegmentBooking $segments
     */
    public function __construct($deferredIssuance = null, \App|C\StructType\FareInfo $fareInfo = null, \App|C\StructType\OfferIn $offer = null, \App|C\ArrayType\ArrayOfPassenger $passengers = null, $promoCode = null, \App|C\ArrayType\ArrayOfSegmentBooking $segments = null)
    {
        $this
            ->setDeferredIssuance($deferredIssuance)
            ->setFareInfo($fareInfo)
            ->setOffer($offer)
            ->setPassengers($passengers)
            ->setPromoCode($promoCode)
            ->setSegments($segments);
    }
    /**
     * Get DeferredIssuance value
     * @return bool|null
     */
    public function getDeferredIssuance()
    {
        return $this->DeferredIssuance;
    }
    /**
     * Set DeferredIssuance value
     * @param bool $deferredIssuance
     * @return \App|C\StructType\PrepareFlightsRequest
     */
    public function setDeferredIssuance($deferredIssuance = null)
    {
        // validation for constraint: boolean
        if (!is_null($deferredIssuance) && !is_bool($deferredIssuance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deferredIssuance, true), gettype($deferredIssuance)), __LINE__);
        }
        $this->DeferredIssuance = $deferredIssuance;
        return $this;
    }
    /**
     * Get FareInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\FareInfo|null
     */
    public function getFareInfo()
    {
        return isset($this->FareInfo) ? $this->FareInfo : null;
    }
    /**
     * Set FareInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\FareInfo $fareInfo
     * @return \App|C\StructType\PrepareFlightsRequest
     */
    public function setFareInfo(\App|C\StructType\FareInfo $fareInfo = null)
    {
        if (is_null($fareInfo) || (is_array($fareInfo) && empty($fareInfo))) {
            unset($this->FareInfo);
        } else {
            $this->FareInfo = $fareInfo;
        }
        return $this;
    }
    /**
     * Get Offer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\OfferIn|null
     */
    public function getOffer()
    {
        return isset($this->Offer) ? $this->Offer : null;
    }
    /**
     * Set Offer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\OfferIn $offer
     * @return \App|C\StructType\PrepareFlightsRequest
     */
    public function setOffer(\App|C\StructType\OfferIn $offer = null)
    {
        if (is_null($offer) || (is_array($offer) && empty($offer))) {
            unset($this->Offer);
        } else {
            $this->Offer = $offer;
        }
        return $this;
    }
    /**
     * Get Passengers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfPassenger|null
     */
    public function getPassengers()
    {
        return isset($this->Passengers) ? $this->Passengers : null;
    }
    /**
     * Set Passengers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfPassenger $passengers
     * @return \App|C\StructType\PrepareFlightsRequest
     */
    public function setPassengers(\App|C\ArrayType\ArrayOfPassenger $passengers = null)
    {
        if (is_null($passengers) || (is_array($passengers) && empty($passengers))) {
            unset($this->Passengers);
        } else {
            $this->Passengers = $passengers;
        }
        return $this;
    }
    /**
     * Get PromoCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromoCode()
    {
        return isset($this->PromoCode) ? $this->PromoCode : null;
    }
    /**
     * Set PromoCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promoCode
     * @return \App|C\StructType\PrepareFlightsRequest
     */
    public function setPromoCode($promoCode = null)
    {
        // validation for constraint: string
        if (!is_null($promoCode) && !is_string($promoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promoCode, true), gettype($promoCode)), __LINE__);
        }
        if (is_null($promoCode) || (is_array($promoCode) && empty($promoCode))) {
            unset($this->PromoCode);
        } else {
            $this->PromoCode = $promoCode;
        }
        return $this;
    }
    /**
     * Get Segments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfSegmentBooking|null
     */
    public function getSegments()
    {
        return isset($this->Segments) ? $this->Segments : null;
    }
    /**
     * Set Segments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfSegmentBooking $segments
     * @return \App|C\StructType\PrepareFlightsRequest
     */
    public function setSegments(\App|C\ArrayType\ArrayOfSegmentBooking $segments = null)
    {
        if (is_null($segments) || (is_array($segments) && empty($segments))) {
            unset($this->Segments);
        } else {
            $this->Segments = $segments;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\PrepareFlightsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
