<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareInfoCancel StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:FareInfoCancel
 * @subpackage Structs
 */
class FareInfoCancel extends ApiObject
{
    /**
     * The EMDTicketFares
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfEMDTicketFare
     */
    public $EMDTicketFares;
    /**
     * The ElectronicDocumentsToCancel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfElectronicDocumentToCancel
     */
    public $ElectronicDocumentsToCancel;
    /**
     * The SaleCurrencyAmountToRefund
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\AmountBase
     */
    public $SaleCurrencyAmountToRefund;
    /**
     * The SaleCurrencyAmountToRefundInAccount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $SaleCurrencyAmountToRefundInAccount;
    /**
     * Constructor method for FareInfoCancel
     * @uses FareInfoCancel::setEMDTicketFares()
     * @uses FareInfoCancel::setElectronicDocumentsToCancel()
     * @uses FareInfoCancel::setSaleCurrencyAmountToRefund()
     * @uses FareInfoCancel::setSaleCurrencyAmountToRefundInAccount()
     * @param \App|C\ArrayType\ArrayOfEMDTicketFare $eMDTicketFares
     * @param \App|C\ArrayType\ArrayOfElectronicDocumentToCancel $electronicDocumentsToCancel
     * @param \App|C\StructType\AmountBase $saleCurrencyAmountToRefund
     * @param float $saleCurrencyAmountToRefundInAccount
     */
    public function __construct(\App|C\ArrayType\ArrayOfEMDTicketFare $eMDTicketFares = null, \App|C\ArrayType\ArrayOfElectronicDocumentToCancel $electronicDocumentsToCancel = null, \App|C\StructType\AmountBase $saleCurrencyAmountToRefund = null, $saleCurrencyAmountToRefundInAccount = null)
    {
        $this
            ->setEMDTicketFares($eMDTicketFares)
            ->setElectronicDocumentsToCancel($electronicDocumentsToCancel)
            ->setSaleCurrencyAmountToRefund($saleCurrencyAmountToRefund)
            ->setSaleCurrencyAmountToRefundInAccount($saleCurrencyAmountToRefundInAccount);
    }
    /**
     * Get EMDTicketFares value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfEMDTicketFare|null
     */
    public function getEMDTicketFares()
    {
        return isset($this->EMDTicketFares) ? $this->EMDTicketFares : null;
    }
    /**
     * Set EMDTicketFares value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfEMDTicketFare $eMDTicketFares
     * @return \App|C\StructType\FareInfoCancel
     */
    public function setEMDTicketFares(\App|C\ArrayType\ArrayOfEMDTicketFare $eMDTicketFares = null)
    {
        if (is_null($eMDTicketFares) || (is_array($eMDTicketFares) && empty($eMDTicketFares))) {
            unset($this->EMDTicketFares);
        } else {
            $this->EMDTicketFares = $eMDTicketFares;
        }
        return $this;
    }
    /**
     * Get ElectronicDocumentsToCancel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfElectronicDocumentToCancel|null
     */
    public function getElectronicDocumentsToCancel()
    {
        return isset($this->ElectronicDocumentsToCancel) ? $this->ElectronicDocumentsToCancel : null;
    }
    /**
     * Set ElectronicDocumentsToCancel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfElectronicDocumentToCancel $electronicDocumentsToCancel
     * @return \App|C\StructType\FareInfoCancel
     */
    public function setElectronicDocumentsToCancel(\App|C\ArrayType\ArrayOfElectronicDocumentToCancel $electronicDocumentsToCancel = null)
    {
        if (is_null($electronicDocumentsToCancel) || (is_array($electronicDocumentsToCancel) && empty($electronicDocumentsToCancel))) {
            unset($this->ElectronicDocumentsToCancel);
        } else {
            $this->ElectronicDocumentsToCancel = $electronicDocumentsToCancel;
        }
        return $this;
    }
    /**
     * Get SaleCurrencyAmountToRefund value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\AmountBase|null
     */
    public function getSaleCurrencyAmountToRefund()
    {
        return isset($this->SaleCurrencyAmountToRefund) ? $this->SaleCurrencyAmountToRefund : null;
    }
    /**
     * Set SaleCurrencyAmountToRefund value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\AmountBase $saleCurrencyAmountToRefund
     * @return \App|C\StructType\FareInfoCancel
     */
    public function setSaleCurrencyAmountToRefund(\App|C\StructType\AmountBase $saleCurrencyAmountToRefund = null)
    {
        if (is_null($saleCurrencyAmountToRefund) || (is_array($saleCurrencyAmountToRefund) && empty($saleCurrencyAmountToRefund))) {
            unset($this->SaleCurrencyAmountToRefund);
        } else {
            $this->SaleCurrencyAmountToRefund = $saleCurrencyAmountToRefund;
        }
        return $this;
    }
    /**
     * Get SaleCurrencyAmountToRefundInAccount value
     * @return float|null
     */
    public function getSaleCurrencyAmountToRefundInAccount()
    {
        return $this->SaleCurrencyAmountToRefundInAccount;
    }
    /**
     * Set SaleCurrencyAmountToRefundInAccount value
     * @param float $saleCurrencyAmountToRefundInAccount
     * @return \App|C\StructType\FareInfoCancel
     */
    public function setSaleCurrencyAmountToRefundInAccount($saleCurrencyAmountToRefundInAccount = null)
    {
        // validation for constraint: float
        if (!is_null($saleCurrencyAmountToRefundInAccount) && !(is_float($saleCurrencyAmountToRefundInAccount) || is_numeric($saleCurrencyAmountToRefundInAccount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($saleCurrencyAmountToRefundInAccount, true), gettype($saleCurrencyAmountToRefundInAccount)), __LINE__);
        }
        $this->SaleCurrencyAmountToRefundInAccount = $saleCurrencyAmountToRefundInAccount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\FareInfoCancel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
