<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerPhone StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomerPhone
 * @subpackage Structs
 */
class CustomerPhone extends ApiObject
{
    /**
     * The PhoneLocationTypeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PhoneLocationTypeCode;
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PhoneNumber;
    /**
     * The PhoneTypeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PhoneTypeCode;
    /**
     * The Ref
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ref;
    /**
     * Constructor method for CustomerPhone
     * @uses CustomerPhone::setPhoneLocationTypeCode()
     * @uses CustomerPhone::setPhoneNumber()
     * @uses CustomerPhone::setPhoneTypeCode()
     * @uses CustomerPhone::setRef()
     * @param string $phoneLocationTypeCode
     * @param string $phoneNumber
     * @param string $phoneTypeCode
     * @param string $ref
     */
    public function __construct($phoneLocationTypeCode = null, $phoneNumber = null, $phoneTypeCode = null, $ref = null)
    {
        $this
            ->setPhoneLocationTypeCode($phoneLocationTypeCode)
            ->setPhoneNumber($phoneNumber)
            ->setPhoneTypeCode($phoneTypeCode)
            ->setRef($ref);
    }
    /**
     * Get PhoneLocationTypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhoneLocationTypeCode()
    {
        return isset($this->PhoneLocationTypeCode) ? $this->PhoneLocationTypeCode : null;
    }
    /**
     * Set PhoneLocationTypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phoneLocationTypeCode
     * @return \App|C\StructType\CustomerPhone
     */
    public function setPhoneLocationTypeCode($phoneLocationTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($phoneLocationTypeCode) && !is_string($phoneLocationTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneLocationTypeCode, true), gettype($phoneLocationTypeCode)), __LINE__);
        }
        if (is_null($phoneLocationTypeCode) || (is_array($phoneLocationTypeCode) && empty($phoneLocationTypeCode))) {
            unset($this->PhoneLocationTypeCode);
        } else {
            $this->PhoneLocationTypeCode = $phoneLocationTypeCode;
        }
        return $this;
    }
    /**
     * Get PhoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return isset($this->PhoneNumber) ? $this->PhoneNumber : null;
    }
    /**
     * Set PhoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phoneNumber
     * @return \App|C\StructType\CustomerPhone
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        if (is_null($phoneNumber) || (is_array($phoneNumber) && empty($phoneNumber))) {
            unset($this->PhoneNumber);
        } else {
            $this->PhoneNumber = $phoneNumber;
        }
        return $this;
    }
    /**
     * Get PhoneTypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhoneTypeCode()
    {
        return isset($this->PhoneTypeCode) ? $this->PhoneTypeCode : null;
    }
    /**
     * Set PhoneTypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phoneTypeCode
     * @return \App|C\StructType\CustomerPhone
     */
    public function setPhoneTypeCode($phoneTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($phoneTypeCode) && !is_string($phoneTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneTypeCode, true), gettype($phoneTypeCode)), __LINE__);
        }
        if (is_null($phoneTypeCode) || (is_array($phoneTypeCode) && empty($phoneTypeCode))) {
            unset($this->PhoneTypeCode);
        } else {
            $this->PhoneTypeCode = $phoneTypeCode;
        }
        return $this;
    }
    /**
     * Get Ref value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRef()
    {
        return isset($this->Ref) ? $this->Ref : null;
    }
    /**
     * Set Ref value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ref
     * @return \App|C\StructType\CustomerPhone
     */
    public function setRef($ref = null)
    {
        // validation for constraint: string
        if (!is_null($ref) && !is_string($ref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ref, true), gettype($ref)), __LINE__);
        }
        if (is_null($ref) || (is_array($ref) && empty($ref))) {
            unset($this->Ref);
        } else {
            $this->Ref = $ref;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\CustomerPhone
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
