<?php

namespace App|C\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerPhone ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCustomerPhone
 * @subpackage Arrays
 */
class ArrayOfCustomerPhone extends AbstractStructArrayBase
{
    /**
     * The CustomerPhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\CustomerPhone[]
     */
    public $CustomerPhone;
    /**
     * Constructor method for ArrayOfCustomerPhone
     * @uses ArrayOfCustomerPhone::setCustomerPhone()
     * @param \App|C\StructType\CustomerPhone[] $customerPhone
     */
    public function __construct(array $customerPhone = array())
    {
        $this
            ->setCustomerPhone($customerPhone);
    }
    /**
     * Get CustomerPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\CustomerPhone[]|null
     */
    public function getCustomerPhone()
    {
        return isset($this->CustomerPhone) ? $this->CustomerPhone : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerPhone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerPhone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerPhoneForArrayConstraintsFromSetCustomerPhone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCustomerPhoneCustomerPhoneItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerPhoneCustomerPhoneItem instanceof \App|C\StructType\CustomerPhone) {
                $invalidValues[] = is_object($arrayOfCustomerPhoneCustomerPhoneItem) ? get_class($arrayOfCustomerPhoneCustomerPhoneItem) : sprintf('%s(%s)', gettype($arrayOfCustomerPhoneCustomerPhoneItem), var_export($arrayOfCustomerPhoneCustomerPhoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomerPhone property can only contain items of type \App|C\StructType\CustomerPhone, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomerPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App|C\StructType\CustomerPhone[] $customerPhone
     * @return \App|C\ArrayType\ArrayOfCustomerPhone
     */
    public function setCustomerPhone(array $customerPhone = array())
    {
        // validation for constraint: array
        if ('' !== ($customerPhoneArrayErrorMessage = self::validateCustomerPhoneForArrayConstraintsFromSetCustomerPhone($customerPhone))) {
            throw new \InvalidArgumentException($customerPhoneArrayErrorMessage, __LINE__);
        }
        if (is_null($customerPhone) || (is_array($customerPhone) && empty($customerPhone))) {
            unset($this->CustomerPhone);
        } else {
            $this->CustomerPhone = $customerPhone;
        }
        return $this;
    }
    /**
     * Add item to CustomerPhone value
     * @throws \InvalidArgumentException
     * @param \App|C\StructType\CustomerPhone $item
     * @return \App|C\ArrayType\ArrayOfCustomerPhone
     */
    public function addToCustomerPhone(\App|C\StructType\CustomerPhone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App|C\StructType\CustomerPhone) {
            throw new \InvalidArgumentException(sprintf('The CustomerPhone property can only contain items of type \App|C\StructType\CustomerPhone, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomerPhone[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \App|C\StructType\CustomerPhone|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \App|C\StructType\CustomerPhone|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \App|C\StructType\CustomerPhone|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \App|C\StructType\CustomerPhone|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \App|C\StructType\CustomerPhone|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerPhone
     */
    public function getAttributeName()
    {
        return 'CustomerPhone';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\ArrayType\ArrayOfCustomerPhone
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
