<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareDisplaySettings StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:FareDisplaySettings
 * @subpackage Structs
 */
class FareDisplaySettings extends FareDisplayBaseSettings
{
    /**
     * The RewardSearch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RewardSearch;
    /**
     * The SaleCurrencyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SaleCurrencyCode;
    /**
     * Constructor method for FareDisplaySettings
     * @uses FareDisplaySettings::setRewardSearch()
     * @uses FareDisplaySettings::setSaleCurrencyCode()
     * @param bool $rewardSearch
     * @param string $saleCurrencyCode
     */
    public function __construct($rewardSearch = null, $saleCurrencyCode = null)
    {
        $this
            ->setRewardSearch($rewardSearch)
            ->setSaleCurrencyCode($saleCurrencyCode);
    }
    /**
     * Get RewardSearch value
     * @return bool|null
     */
    public function getRewardSearch()
    {
        return $this->RewardSearch;
    }
    /**
     * Set RewardSearch value
     * @param bool $rewardSearch
     * @return \App|C\StructType\FareDisplaySettings
     */
    public function setRewardSearch($rewardSearch = null)
    {
        // validation for constraint: boolean
        if (!is_null($rewardSearch) && !is_bool($rewardSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rewardSearch, true), gettype($rewardSearch)), __LINE__);
        }
        $this->RewardSearch = $rewardSearch;
        return $this;
    }
    /**
     * Get SaleCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleCurrencyCode()
    {
        return isset($this->SaleCurrencyCode) ? $this->SaleCurrencyCode : null;
    }
    /**
     * Set SaleCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleCurrencyCode
     * @return \App|C\StructType\FareDisplaySettings
     */
    public function setSaleCurrencyCode($saleCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleCurrencyCode) && !is_string($saleCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleCurrencyCode, true), gettype($saleCurrencyCode)), __LINE__);
        }
        if (is_null($saleCurrencyCode) || (is_array($saleCurrencyCode) && empty($saleCurrencyCode))) {
            unset($this->SaleCurrencyCode);
        } else {
            $this->SaleCurrencyCode = $saleCurrencyCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\FareDisplaySettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
