<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BoardingPassInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BoardingPassInfo
 * @subpackage Structs
 */
class BoardingPassInfo extends ETTicketTarget
{
    /**
     * The HttpLink
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HttpLink;
    /**
     * The OriginDestinationOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OriginDestinationOrder;
    /**
     * The RefItinerary
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefItinerary;
    /**
     * Constructor method for BoardingPassInfo
     * @uses BoardingPassInfo::setHttpLink()
     * @uses BoardingPassInfo::setOriginDestinationOrder()
     * @uses BoardingPassInfo::setRefItinerary()
     * @param string $httpLink
     * @param int $originDestinationOrder
     * @param string $refItinerary
     */
    public function __construct($httpLink = null, $originDestinationOrder = null, $refItinerary = null)
    {
        $this
            ->setHttpLink($httpLink)
            ->setOriginDestinationOrder($originDestinationOrder)
            ->setRefItinerary($refItinerary);
    }
    /**
     * Get HttpLink value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHttpLink()
    {
        return isset($this->HttpLink) ? $this->HttpLink : null;
    }
    /**
     * Set HttpLink value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $httpLink
     * @return \App|C\StructType\BoardingPassInfo
     */
    public function setHttpLink($httpLink = null)
    {
        // validation for constraint: string
        if (!is_null($httpLink) && !is_string($httpLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($httpLink, true), gettype($httpLink)), __LINE__);
        }
        if (is_null($httpLink) || (is_array($httpLink) && empty($httpLink))) {
            unset($this->HttpLink);
        } else {
            $this->HttpLink = $httpLink;
        }
        return $this;
    }
    /**
     * Get OriginDestinationOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOriginDestinationOrder()
    {
        return isset($this->OriginDestinationOrder) ? $this->OriginDestinationOrder : null;
    }
    /**
     * Set OriginDestinationOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $originDestinationOrder
     * @return \App|C\StructType\BoardingPassInfo
     */
    public function setOriginDestinationOrder($originDestinationOrder = null)
    {
        // validation for constraint: int
        if (!is_null($originDestinationOrder) && !(is_int($originDestinationOrder) || ctype_digit($originDestinationOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originDestinationOrder, true), gettype($originDestinationOrder)), __LINE__);
        }
        if (is_null($originDestinationOrder) || (is_array($originDestinationOrder) && empty($originDestinationOrder))) {
            unset($this->OriginDestinationOrder);
        } else {
            $this->OriginDestinationOrder = $originDestinationOrder;
        }
        return $this;
    }
    /**
     * Get RefItinerary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefItinerary()
    {
        return isset($this->RefItinerary) ? $this->RefItinerary : null;
    }
    /**
     * Set RefItinerary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refItinerary
     * @return \App|C\StructType\BoardingPassInfo
     */
    public function setRefItinerary($refItinerary = null)
    {
        // validation for constraint: string
        if (!is_null($refItinerary) && !is_string($refItinerary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refItinerary, true), gettype($refItinerary)), __LINE__);
        }
        if (is_null($refItinerary) || (is_array($refItinerary) && empty($refItinerary))) {
            unset($this->RefItinerary);
        } else {
            $this->RefItinerary = $refItinerary;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\BoardingPassInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
