<?php

namespace App|C\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Search ServiceType
 * @subpackage Services
 */
class Search extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SearchFlights
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\SearchFlights $parameters
     * @return \App|C\StructType\SearchFlightsResponse|bool
     */
    public function SearchFlights(\App|C\StructType\SearchFlights $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SearchFlights($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchBooking
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\SearchBooking $parameters
     * @return \App|C\StructType\SearchBookingResponse|bool
     */
    public function SearchBooking(\App|C\StructType\SearchBooking $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SearchBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchFlightsForExchange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\SearchFlightsForExchange $parameters
     * @return \App|C\StructType\SearchFlightsForExchangeResponse|bool
     */
    public function SearchFlightsForExchange(\App|C\StructType\SearchFlightsForExchange $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SearchFlightsForExchange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App|C\StructType\SearchBookingResponse|\App|C\StructType\SearchFlightsForExchangeResponse|\App|C\StructType\SearchFlightsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
