<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TaxDetails
 * @subpackage Structs
 */
class TaxDetails extends ApiObject
{
    /**
     * The BaseCurrentyAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BaseCurrentyAmount;
    /**
     * The IsIncludedInBaseFare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsIncludedInBaseFare;
    /**
     * The IsRefundable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsRefundable;
    /**
     * The Rate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Rate;
    /**
     * The RateApplicableOnLegOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RateApplicableOnLegOnly;
    /**
     * The TaxCurrencyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxCurrencyCode;
    /**
     * The TaxCurrentyAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TaxCurrentyAmount;
    /**
     * Constructor method for TaxDetails
     * @uses TaxDetails::setBaseCurrentyAmount()
     * @uses TaxDetails::setIsIncludedInBaseFare()
     * @uses TaxDetails::setIsRefundable()
     * @uses TaxDetails::setRate()
     * @uses TaxDetails::setRateApplicableOnLegOnly()
     * @uses TaxDetails::setTaxCurrencyCode()
     * @uses TaxDetails::setTaxCurrentyAmount()
     * @param float $baseCurrentyAmount
     * @param bool $isIncludedInBaseFare
     * @param bool $isRefundable
     * @param float $rate
     * @param bool $rateApplicableOnLegOnly
     * @param string $taxCurrencyCode
     * @param float $taxCurrentyAmount
     */
    public function __construct($baseCurrentyAmount = null, $isIncludedInBaseFare = null, $isRefundable = null, $rate = null, $rateApplicableOnLegOnly = null, $taxCurrencyCode = null, $taxCurrentyAmount = null)
    {
        $this
            ->setBaseCurrentyAmount($baseCurrentyAmount)
            ->setIsIncludedInBaseFare($isIncludedInBaseFare)
            ->setIsRefundable($isRefundable)
            ->setRate($rate)
            ->setRateApplicableOnLegOnly($rateApplicableOnLegOnly)
            ->setTaxCurrencyCode($taxCurrencyCode)
            ->setTaxCurrentyAmount($taxCurrentyAmount);
    }
    /**
     * Get BaseCurrentyAmount value
     * @return float|null
     */
    public function getBaseCurrentyAmount()
    {
        return $this->BaseCurrentyAmount;
    }
    /**
     * Set BaseCurrentyAmount value
     * @param float $baseCurrentyAmount
     * @return \App|C\StructType\TaxDetails
     */
    public function setBaseCurrentyAmount($baseCurrentyAmount = null)
    {
        // validation for constraint: float
        if (!is_null($baseCurrentyAmount) && !(is_float($baseCurrentyAmount) || is_numeric($baseCurrentyAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseCurrentyAmount, true), gettype($baseCurrentyAmount)), __LINE__);
        }
        $this->BaseCurrentyAmount = $baseCurrentyAmount;
        return $this;
    }
    /**
     * Get IsIncludedInBaseFare value
     * @return bool|null
     */
    public function getIsIncludedInBaseFare()
    {
        return $this->IsIncludedInBaseFare;
    }
    /**
     * Set IsIncludedInBaseFare value
     * @param bool $isIncludedInBaseFare
     * @return \App|C\StructType\TaxDetails
     */
    public function setIsIncludedInBaseFare($isIncludedInBaseFare = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIncludedInBaseFare) && !is_bool($isIncludedInBaseFare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIncludedInBaseFare, true), gettype($isIncludedInBaseFare)), __LINE__);
        }
        $this->IsIncludedInBaseFare = $isIncludedInBaseFare;
        return $this;
    }
    /**
     * Get IsRefundable value
     * @return bool|null
     */
    public function getIsRefundable()
    {
        return $this->IsRefundable;
    }
    /**
     * Set IsRefundable value
     * @param bool $isRefundable
     * @return \App|C\StructType\TaxDetails
     */
    public function setIsRefundable($isRefundable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRefundable) && !is_bool($isRefundable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRefundable, true), gettype($isRefundable)), __LINE__);
        }
        $this->IsRefundable = $isRefundable;
        return $this;
    }
    /**
     * Get Rate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRate()
    {
        return isset($this->Rate) ? $this->Rate : null;
    }
    /**
     * Set Rate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $rate
     * @return \App|C\StructType\TaxDetails
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        if (is_null($rate) || (is_array($rate) && empty($rate))) {
            unset($this->Rate);
        } else {
            $this->Rate = $rate;
        }
        return $this;
    }
    /**
     * Get RateApplicableOnLegOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRateApplicableOnLegOnly()
    {
        return isset($this->RateApplicableOnLegOnly) ? $this->RateApplicableOnLegOnly : null;
    }
    /**
     * Set RateApplicableOnLegOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $rateApplicableOnLegOnly
     * @return \App|C\StructType\TaxDetails
     */
    public function setRateApplicableOnLegOnly($rateApplicableOnLegOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($rateApplicableOnLegOnly) && !is_bool($rateApplicableOnLegOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rateApplicableOnLegOnly, true), gettype($rateApplicableOnLegOnly)), __LINE__);
        }
        if (is_null($rateApplicableOnLegOnly) || (is_array($rateApplicableOnLegOnly) && empty($rateApplicableOnLegOnly))) {
            unset($this->RateApplicableOnLegOnly);
        } else {
            $this->RateApplicableOnLegOnly = $rateApplicableOnLegOnly;
        }
        return $this;
    }
    /**
     * Get TaxCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxCurrencyCode()
    {
        return isset($this->TaxCurrencyCode) ? $this->TaxCurrencyCode : null;
    }
    /**
     * Set TaxCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxCurrencyCode
     * @return \App|C\StructType\TaxDetails
     */
    public function setTaxCurrencyCode($taxCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxCurrencyCode) && !is_string($taxCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCurrencyCode, true), gettype($taxCurrencyCode)), __LINE__);
        }
        if (is_null($taxCurrencyCode) || (is_array($taxCurrencyCode) && empty($taxCurrencyCode))) {
            unset($this->TaxCurrencyCode);
        } else {
            $this->TaxCurrencyCode = $taxCurrencyCode;
        }
        return $this;
    }
    /**
     * Get TaxCurrentyAmount value
     * @return float|null
     */
    public function getTaxCurrentyAmount()
    {
        return $this->TaxCurrentyAmount;
    }
    /**
     * Set TaxCurrentyAmount value
     * @param float $taxCurrentyAmount
     * @return \App|C\StructType\TaxDetails
     */
    public function setTaxCurrentyAmount($taxCurrentyAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxCurrentyAmount) && !(is_float($taxCurrentyAmount) || is_numeric($taxCurrentyAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxCurrentyAmount, true), gettype($taxCurrentyAmount)), __LINE__);
        }
        $this->TaxCurrentyAmount = $taxCurrentyAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\TaxDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
