<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TTIExceptionDetail StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TTIExceptionDetail
 * @subpackage Structs
 */
class TTIExceptionDetail extends AbstractStructBase
{
    /**
     * The dataField
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfArrayOfKeyValueOfanyTypeanyTypeKeyValueOfanyTypeanyType
     */
    public $dataField;
    /**
     * The expectationLevelField
     * @var string
     */
    public $expectationLevelField;
    /**
     * The expectationLevelFieldSpecified
     * @var bool
     */
    public $expectationLevelFieldSpecified;
    /**
     * The helpLinkField
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $helpLinkField;
    /**
     * The innerExceptionField
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \App|C\StructType\TTIExceptionDetail
     */
    public $innerExceptionField;
    /**
     * The messageField
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $messageField;
    /**
     * The recordIdField
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $recordIdField;
    /**
     * The stackTraceField
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $stackTraceField;
    /**
     * The typeField
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $typeField;
    /**
     * Constructor method for TTIExceptionDetail
     * @uses TTIExceptionDetail::setDataField()
     * @uses TTIExceptionDetail::setExpectationLevelField()
     * @uses TTIExceptionDetail::setExpectationLevelFieldSpecified()
     * @uses TTIExceptionDetail::setHelpLinkField()
     * @uses TTIExceptionDetail::setInnerExceptionField()
     * @uses TTIExceptionDetail::setMessageField()
     * @uses TTIExceptionDetail::setRecordIdField()
     * @uses TTIExceptionDetail::setStackTraceField()
     * @uses TTIExceptionDetail::setTypeField()
     * @param \App|C\ArrayType\ArrayOfArrayOfKeyValueOfanyTypeanyTypeKeyValueOfanyTypeanyType $dataField
     * @param string $expectationLevelField
     * @param bool $expectationLevelFieldSpecified
     * @param string $helpLinkField
     * @param \App|C\StructType\TTIExceptionDetail $innerExceptionField
     * @param string $messageField
     * @param string $recordIdField
     * @param string $stackTraceField
     * @param string $typeField
     */
    public function __construct(\App|C\ArrayType\ArrayOfArrayOfKeyValueOfanyTypeanyTypeKeyValueOfanyTypeanyType $dataField = null, $expectationLevelField = null, $expectationLevelFieldSpecified = null, $helpLinkField = null, \App|C\StructType\TTIExceptionDetail $innerExceptionField = null, $messageField = null, $recordIdField = null, $stackTraceField = null, $typeField = null)
    {
        $this
            ->setDataField($dataField)
            ->setExpectationLevelField($expectationLevelField)
            ->setExpectationLevelFieldSpecified($expectationLevelFieldSpecified)
            ->setHelpLinkField($helpLinkField)
            ->setInnerExceptionField($innerExceptionField)
            ->setMessageField($messageField)
            ->setRecordIdField($recordIdField)
            ->setStackTraceField($stackTraceField)
            ->setTypeField($typeField);
    }
    /**
     * Get dataField value
     * @return \App|C\ArrayType\ArrayOfArrayOfKeyValueOfanyTypeanyTypeKeyValueOfanyTypeanyType|null
     */
    public function getDataField()
    {
        return $this->dataField;
    }
    /**
     * Set dataField value
     * @param \App|C\ArrayType\ArrayOfArrayOfKeyValueOfanyTypeanyTypeKeyValueOfanyTypeanyType $dataField
     * @return \App|C\StructType\TTIExceptionDetail
     */
    public function setDataField(\App|C\ArrayType\ArrayOfArrayOfKeyValueOfanyTypeanyTypeKeyValueOfanyTypeanyType $dataField = null)
    {
        $this->dataField = $dataField;
        return $this;
    }
    /**
     * Get expectationLevelField value
     * @return string|null
     */
    public function getExpectationLevelField()
    {
        return $this->expectationLevelField;
    }
    /**
     * Set expectationLevelField value
     * @uses \App|C\EnumType\ExpectationLevel::valueIsValid()
     * @uses \App|C\EnumType\ExpectationLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $expectationLevelField
     * @return \App|C\StructType\TTIExceptionDetail
     */
    public function setExpectationLevelField($expectationLevelField = null)
    {
        // validation for constraint: enumeration
        if (!\App|C\EnumType\ExpectationLevel::valueIsValid($expectationLevelField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App|C\EnumType\ExpectationLevel', is_array($expectationLevelField) ? implode(', ', $expectationLevelField) : var_export($expectationLevelField, true), implode(', ', \App|C\EnumType\ExpectationLevel::getValidValues())), __LINE__);
        }
        $this->expectationLevelField = $expectationLevelField;
        return $this;
    }
    /**
     * Get expectationLevelFieldSpecified value
     * @return bool|null
     */
    public function getExpectationLevelFieldSpecified()
    {
        return $this->expectationLevelFieldSpecified;
    }
    /**
     * Set expectationLevelFieldSpecified value
     * @param bool $expectationLevelFieldSpecified
     * @return \App|C\StructType\TTIExceptionDetail
     */
    public function setExpectationLevelFieldSpecified($expectationLevelFieldSpecified = null)
    {
        // validation for constraint: boolean
        if (!is_null($expectationLevelFieldSpecified) && !is_bool($expectationLevelFieldSpecified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expectationLevelFieldSpecified, true), gettype($expectationLevelFieldSpecified)), __LINE__);
        }
        $this->expectationLevelFieldSpecified = $expectationLevelFieldSpecified;
        return $this;
    }
    /**
     * Get helpLinkField value
     * @return string|null
     */
    public function getHelpLinkField()
    {
        return $this->helpLinkField;
    }
    /**
     * Set helpLinkField value
     * @param string $helpLinkField
     * @return \App|C\StructType\TTIExceptionDetail
     */
    public function setHelpLinkField($helpLinkField = null)
    {
        // validation for constraint: string
        if (!is_null($helpLinkField) && !is_string($helpLinkField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($helpLinkField, true), gettype($helpLinkField)), __LINE__);
        }
        $this->helpLinkField = $helpLinkField;
        return $this;
    }
    /**
     * Get innerExceptionField value
     * @return \App|C\StructType\TTIExceptionDetail|null
     */
    public function getInnerExceptionField()
    {
        return $this->innerExceptionField;
    }
    /**
     * Set innerExceptionField value
     * @param \App|C\StructType\TTIExceptionDetail $innerExceptionField
     * @return \App|C\StructType\TTIExceptionDetail
     */
    public function setInnerExceptionField(\App|C\StructType\TTIExceptionDetail $innerExceptionField = null)
    {
        $this->innerExceptionField = $innerExceptionField;
        return $this;
    }
    /**
     * Get messageField value
     * @return string|null
     */
    public function getMessageField()
    {
        return $this->messageField;
    }
    /**
     * Set messageField value
     * @param string $messageField
     * @return \App|C\StructType\TTIExceptionDetail
     */
    public function setMessageField($messageField = null)
    {
        // validation for constraint: string
        if (!is_null($messageField) && !is_string($messageField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageField, true), gettype($messageField)), __LINE__);
        }
        $this->messageField = $messageField;
        return $this;
    }
    /**
     * Get recordIdField value
     * @return string|null
     */
    public function getRecordIdField()
    {
        return $this->recordIdField;
    }
    /**
     * Set recordIdField value
     * @param string $recordIdField
     * @return \App|C\StructType\TTIExceptionDetail
     */
    public function setRecordIdField($recordIdField = null)
    {
        // validation for constraint: string
        if (!is_null($recordIdField) && !is_string($recordIdField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordIdField, true), gettype($recordIdField)), __LINE__);
        }
        $this->recordIdField = $recordIdField;
        return $this;
    }
    /**
     * Get stackTraceField value
     * @return string|null
     */
    public function getStackTraceField()
    {
        return $this->stackTraceField;
    }
    /**
     * Set stackTraceField value
     * @param string $stackTraceField
     * @return \App|C\StructType\TTIExceptionDetail
     */
    public function setStackTraceField($stackTraceField = null)
    {
        // validation for constraint: string
        if (!is_null($stackTraceField) && !is_string($stackTraceField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stackTraceField, true), gettype($stackTraceField)), __LINE__);
        }
        $this->stackTraceField = $stackTraceField;
        return $this;
    }
    /**
     * Get typeField value
     * @return string|null
     */
    public function getTypeField()
    {
        return $this->typeField;
    }
    /**
     * Set typeField value
     * @param string $typeField
     * @return \App|C\StructType\TTIExceptionDetail
     */
    public function setTypeField($typeField = null)
    {
        // validation for constraint: string
        if (!is_null($typeField) && !is_string($typeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeField, true), gettype($typeField)), __LINE__);
        }
        $this->typeField = $typeField;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\TTIExceptionDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
