<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialServiceDataDoca StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SpecialServiceDataDoca
 * @subpackage Structs
 */
class SpecialServiceDataDoca extends ApiObject
{
    /**
     * The AddressDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressDetails;
    /**
     * The AddressTypeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressTypeCode;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CountryCode;
    /**
     * The StateProvince
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StateProvince;
    /**
     * The ZipPostalCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ZipPostalCode;
    /**
     * Constructor method for SpecialServiceDataDoca
     * @uses SpecialServiceDataDoca::setAddressDetails()
     * @uses SpecialServiceDataDoca::setAddressTypeCode()
     * @uses SpecialServiceDataDoca::setCity()
     * @uses SpecialServiceDataDoca::setCountryCode()
     * @uses SpecialServiceDataDoca::setStateProvince()
     * @uses SpecialServiceDataDoca::setZipPostalCode()
     * @param string $addressDetails
     * @param string $addressTypeCode
     * @param string $city
     * @param string $countryCode
     * @param string $stateProvince
     * @param string $zipPostalCode
     */
    public function __construct($addressDetails = null, $addressTypeCode = null, $city = null, $countryCode = null, $stateProvince = null, $zipPostalCode = null)
    {
        $this
            ->setAddressDetails($addressDetails)
            ->setAddressTypeCode($addressTypeCode)
            ->setCity($city)
            ->setCountryCode($countryCode)
            ->setStateProvince($stateProvince)
            ->setZipPostalCode($zipPostalCode);
    }
    /**
     * Get AddressDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressDetails()
    {
        return isset($this->AddressDetails) ? $this->AddressDetails : null;
    }
    /**
     * Set AddressDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressDetails
     * @return \App|C\StructType\SpecialServiceDataDoca
     */
    public function setAddressDetails($addressDetails = null)
    {
        // validation for constraint: string
        if (!is_null($addressDetails) && !is_string($addressDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressDetails, true), gettype($addressDetails)), __LINE__);
        }
        if (is_null($addressDetails) || (is_array($addressDetails) && empty($addressDetails))) {
            unset($this->AddressDetails);
        } else {
            $this->AddressDetails = $addressDetails;
        }
        return $this;
    }
    /**
     * Get AddressTypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressTypeCode()
    {
        return isset($this->AddressTypeCode) ? $this->AddressTypeCode : null;
    }
    /**
     * Set AddressTypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressTypeCode
     * @return \App|C\StructType\SpecialServiceDataDoca
     */
    public function setAddressTypeCode($addressTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($addressTypeCode) && !is_string($addressTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressTypeCode, true), gettype($addressTypeCode)), __LINE__);
        }
        if (is_null($addressTypeCode) || (is_array($addressTypeCode) && empty($addressTypeCode))) {
            unset($this->AddressTypeCode);
        } else {
            $this->AddressTypeCode = $addressTypeCode;
        }
        return $this;
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \App|C\StructType\SpecialServiceDataDoca
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Get CountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryCode()
    {
        return isset($this->CountryCode) ? $this->CountryCode : null;
    }
    /**
     * Set CountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryCode
     * @return \App|C\StructType\SpecialServiceDataDoca
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        if (is_null($countryCode) || (is_array($countryCode) && empty($countryCode))) {
            unset($this->CountryCode);
        } else {
            $this->CountryCode = $countryCode;
        }
        return $this;
    }
    /**
     * Get StateProvince value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStateProvince()
    {
        return isset($this->StateProvince) ? $this->StateProvince : null;
    }
    /**
     * Set StateProvince value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stateProvince
     * @return \App|C\StructType\SpecialServiceDataDoca
     */
    public function setStateProvince($stateProvince = null)
    {
        // validation for constraint: string
        if (!is_null($stateProvince) && !is_string($stateProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateProvince, true), gettype($stateProvince)), __LINE__);
        }
        if (is_null($stateProvince) || (is_array($stateProvince) && empty($stateProvince))) {
            unset($this->StateProvince);
        } else {
            $this->StateProvince = $stateProvince;
        }
        return $this;
    }
    /**
     * Get ZipPostalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZipPostalCode()
    {
        return isset($this->ZipPostalCode) ? $this->ZipPostalCode : null;
    }
    /**
     * Set ZipPostalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zipPostalCode
     * @return \App|C\StructType\SpecialServiceDataDoca
     */
    public function setZipPostalCode($zipPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipPostalCode) && !is_string($zipPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipPostalCode, true), gettype($zipPostalCode)), __LINE__);
        }
        if (is_null($zipPostalCode) || (is_array($zipPostalCode) && empty($zipPostalCode))) {
            unset($this->ZipPostalCode);
        } else {
            $this->ZipPostalCode = $zipPostalCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\SpecialServiceDataDoca
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
