<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FaultExceptionInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:FaultExceptionInfo
 * @subpackage Structs
 */
class FaultExceptionInfo extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The ExceptionData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfPairOfstringstring
     */
    public $ExceptionData;
    /**
     * The ExceptionTypeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExceptionTypeName;
    /**
     * The FaultType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FaultType;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The PlainText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PlainText;
    /**
     * The RecordId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecordId;
    /**
     * The StackTrace
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StackTrace;
    /**
     * Constructor method for FaultExceptionInfo
     * @uses FaultExceptionInfo::setCode()
     * @uses FaultExceptionInfo::setExceptionData()
     * @uses FaultExceptionInfo::setExceptionTypeName()
     * @uses FaultExceptionInfo::setFaultType()
     * @uses FaultExceptionInfo::setMessage()
     * @uses FaultExceptionInfo::setPlainText()
     * @uses FaultExceptionInfo::setRecordId()
     * @uses FaultExceptionInfo::setStackTrace()
     * @param string $code
     * @param \App|C\ArrayType\ArrayOfPairOfstringstring $exceptionData
     * @param string $exceptionTypeName
     * @param string $faultType
     * @param string $message
     * @param string $plainText
     * @param string $recordId
     * @param string $stackTrace
     */
    public function __construct($code = null, \App|C\ArrayType\ArrayOfPairOfstringstring $exceptionData = null, $exceptionTypeName = null, $faultType = null, $message = null, $plainText = null, $recordId = null, $stackTrace = null)
    {
        $this
            ->setCode($code)
            ->setExceptionData($exceptionData)
            ->setExceptionTypeName($exceptionTypeName)
            ->setFaultType($faultType)
            ->setMessage($message)
            ->setPlainText($plainText)
            ->setRecordId($recordId)
            ->setStackTrace($stackTrace);
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \App|C\StructType\FaultExceptionInfo
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get ExceptionData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfPairOfstringstring|null
     */
    public function getExceptionData()
    {
        return isset($this->ExceptionData) ? $this->ExceptionData : null;
    }
    /**
     * Set ExceptionData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfPairOfstringstring $exceptionData
     * @return \App|C\StructType\FaultExceptionInfo
     */
    public function setExceptionData(\App|C\ArrayType\ArrayOfPairOfstringstring $exceptionData = null)
    {
        if (is_null($exceptionData) || (is_array($exceptionData) && empty($exceptionData))) {
            unset($this->ExceptionData);
        } else {
            $this->ExceptionData = $exceptionData;
        }
        return $this;
    }
    /**
     * Get ExceptionTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExceptionTypeName()
    {
        return isset($this->ExceptionTypeName) ? $this->ExceptionTypeName : null;
    }
    /**
     * Set ExceptionTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exceptionTypeName
     * @return \App|C\StructType\FaultExceptionInfo
     */
    public function setExceptionTypeName($exceptionTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionTypeName) && !is_string($exceptionTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exceptionTypeName, true), gettype($exceptionTypeName)), __LINE__);
        }
        if (is_null($exceptionTypeName) || (is_array($exceptionTypeName) && empty($exceptionTypeName))) {
            unset($this->ExceptionTypeName);
        } else {
            $this->ExceptionTypeName = $exceptionTypeName;
        }
        return $this;
    }
    /**
     * Get FaultType value
     * @return string|null
     */
    public function getFaultType()
    {
        return $this->FaultType;
    }
    /**
     * Set FaultType value
     * @uses \App|C\EnumType\FaultType::valueIsValid()
     * @uses \App|C\EnumType\FaultType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $faultType
     * @return \App|C\StructType\FaultExceptionInfo
     */
    public function setFaultType($faultType = null)
    {
        // validation for constraint: enumeration
        if (!\App|C\EnumType\FaultType::valueIsValid($faultType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App|C\EnumType\FaultType', is_array($faultType) ? implode(', ', $faultType) : var_export($faultType, true), implode(', ', \App|C\EnumType\FaultType::getValidValues())), __LINE__);
        }
        $this->FaultType = $faultType;
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \App|C\StructType\FaultExceptionInfo
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get PlainText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlainText()
    {
        return isset($this->PlainText) ? $this->PlainText : null;
    }
    /**
     * Set PlainText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plainText
     * @return \App|C\StructType\FaultExceptionInfo
     */
    public function setPlainText($plainText = null)
    {
        // validation for constraint: string
        if (!is_null($plainText) && !is_string($plainText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plainText, true), gettype($plainText)), __LINE__);
        }
        if (is_null($plainText) || (is_array($plainText) && empty($plainText))) {
            unset($this->PlainText);
        } else {
            $this->PlainText = $plainText;
        }
        return $this;
    }
    /**
     * Get RecordId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecordId()
    {
        return isset($this->RecordId) ? $this->RecordId : null;
    }
    /**
     * Set RecordId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recordId
     * @return \App|C\StructType\FaultExceptionInfo
     */
    public function setRecordId($recordId = null)
    {
        // validation for constraint: string
        if (!is_null($recordId) && !is_string($recordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordId, true), gettype($recordId)), __LINE__);
        }
        if (is_null($recordId) || (is_array($recordId) && empty($recordId))) {
            unset($this->RecordId);
        } else {
            $this->RecordId = $recordId;
        }
        return $this;
    }
    /**
     * Get StackTrace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStackTrace()
    {
        return isset($this->StackTrace) ? $this->StackTrace : null;
    }
    /**
     * Set StackTrace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stackTrace
     * @return \App|C\StructType\FaultExceptionInfo
     */
    public function setStackTrace($stackTrace = null)
    {
        // validation for constraint: string
        if (!is_null($stackTrace) && !is_string($stackTrace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stackTrace, true), gettype($stackTrace)), __LINE__);
        }
        if (is_null($stackTrace) || (is_array($stackTrace) && empty($stackTrace))) {
            unset($this->StackTrace);
        } else {
            $this->StackTrace = $stackTrace;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\FaultExceptionInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
