<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ElectronicDocumentToCancel StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ElectronicDocumentToCancel
 * @subpackage Structs
 */
class ElectronicDocumentToCancel extends ElectronicDocument
{
    /**
     * The CouponOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CouponOrder;
    /**
     * The SaleCurrencyAmountToRefund
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\AmountSummary
     */
    public $SaleCurrencyAmountToRefund;
    /**
     * Constructor method for ElectronicDocumentToCancel
     * @uses ElectronicDocumentToCancel::setCouponOrder()
     * @uses ElectronicDocumentToCancel::setSaleCurrencyAmountToRefund()
     * @param int $couponOrder
     * @param \App|C\StructType\AmountSummary $saleCurrencyAmountToRefund
     */
    public function __construct($couponOrder = null, \App|C\StructType\AmountSummary $saleCurrencyAmountToRefund = null)
    {
        $this
            ->setCouponOrder($couponOrder)
            ->setSaleCurrencyAmountToRefund($saleCurrencyAmountToRefund);
    }
    /**
     * Get CouponOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCouponOrder()
    {
        return isset($this->CouponOrder) ? $this->CouponOrder : null;
    }
    /**
     * Set CouponOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $couponOrder
     * @return \App|C\StructType\ElectronicDocumentToCancel
     */
    public function setCouponOrder($couponOrder = null)
    {
        // validation for constraint: int
        if (!is_null($couponOrder) && !(is_int($couponOrder) || ctype_digit($couponOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($couponOrder, true), gettype($couponOrder)), __LINE__);
        }
        if (is_null($couponOrder) || (is_array($couponOrder) && empty($couponOrder))) {
            unset($this->CouponOrder);
        } else {
            $this->CouponOrder = $couponOrder;
        }
        return $this;
    }
    /**
     * Get SaleCurrencyAmountToRefund value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\AmountSummary|null
     */
    public function getSaleCurrencyAmountToRefund()
    {
        return isset($this->SaleCurrencyAmountToRefund) ? $this->SaleCurrencyAmountToRefund : null;
    }
    /**
     * Set SaleCurrencyAmountToRefund value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\AmountSummary $saleCurrencyAmountToRefund
     * @return \App|C\StructType\ElectronicDocumentToCancel
     */
    public function setSaleCurrencyAmountToRefund(\App|C\StructType\AmountSummary $saleCurrencyAmountToRefund = null)
    {
        if (is_null($saleCurrencyAmountToRefund) || (is_array($saleCurrencyAmountToRefund) && empty($saleCurrencyAmountToRefund))) {
            unset($this->SaleCurrencyAmountToRefund);
        } else {
            $this->SaleCurrencyAmountToRefund = $saleCurrencyAmountToRefund;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\ElectronicDocumentToCancel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
