<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ETCoupon StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ETCoupon
 * @subpackage Structs
 */
class ETCoupon extends ApiObject
{
    /**
     * The CouponOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CouponOrder;
    /**
     * The FinalStatusInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\FinalStatusInfo
     */
    public $FinalStatusInfo;
    /**
     * The SegmentSold
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\SegmentSold
     */
    public $SegmentSold;
    /**
     * The StatusCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusCode;
    /**
     * Constructor method for ETCoupon
     * @uses ETCoupon::setCouponOrder()
     * @uses ETCoupon::setFinalStatusInfo()
     * @uses ETCoupon::setSegmentSold()
     * @uses ETCoupon::setStatusCode()
     * @param int $couponOrder
     * @param \App|C\StructType\FinalStatusInfo $finalStatusInfo
     * @param \App|C\StructType\SegmentSold $segmentSold
     * @param string $statusCode
     */
    public function __construct($couponOrder = null, \App|C\StructType\FinalStatusInfo $finalStatusInfo = null, \App|C\StructType\SegmentSold $segmentSold = null, $statusCode = null)
    {
        $this
            ->setCouponOrder($couponOrder)
            ->setFinalStatusInfo($finalStatusInfo)
            ->setSegmentSold($segmentSold)
            ->setStatusCode($statusCode);
    }
    /**
     * Get CouponOrder value
     * @return int|null
     */
    public function getCouponOrder()
    {
        return $this->CouponOrder;
    }
    /**
     * Set CouponOrder value
     * @param int $couponOrder
     * @return \App|C\StructType\ETCoupon
     */
    public function setCouponOrder($couponOrder = null)
    {
        // validation for constraint: int
        if (!is_null($couponOrder) && !(is_int($couponOrder) || ctype_digit($couponOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($couponOrder, true), gettype($couponOrder)), __LINE__);
        }
        $this->CouponOrder = $couponOrder;
        return $this;
    }
    /**
     * Get FinalStatusInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\FinalStatusInfo|null
     */
    public function getFinalStatusInfo()
    {
        return isset($this->FinalStatusInfo) ? $this->FinalStatusInfo : null;
    }
    /**
     * Set FinalStatusInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\FinalStatusInfo $finalStatusInfo
     * @return \App|C\StructType\ETCoupon
     */
    public function setFinalStatusInfo(\App|C\StructType\FinalStatusInfo $finalStatusInfo = null)
    {
        if (is_null($finalStatusInfo) || (is_array($finalStatusInfo) && empty($finalStatusInfo))) {
            unset($this->FinalStatusInfo);
        } else {
            $this->FinalStatusInfo = $finalStatusInfo;
        }
        return $this;
    }
    /**
     * Get SegmentSold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\SegmentSold|null
     */
    public function getSegmentSold()
    {
        return isset($this->SegmentSold) ? $this->SegmentSold : null;
    }
    /**
     * Set SegmentSold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\SegmentSold $segmentSold
     * @return \App|C\StructType\ETCoupon
     */
    public function setSegmentSold(\App|C\StructType\SegmentSold $segmentSold = null)
    {
        if (is_null($segmentSold) || (is_array($segmentSold) && empty($segmentSold))) {
            unset($this->SegmentSold);
        } else {
            $this->SegmentSold = $segmentSold;
        }
        return $this;
    }
    /**
     * Get StatusCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusCode()
    {
        return isset($this->StatusCode) ? $this->StatusCode : null;
    }
    /**
     * Set StatusCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusCode
     * @return \App|C\StructType\ETCoupon
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        if (is_null($statusCode) || (is_array($statusCode) && empty($statusCode))) {
            unset($this->StatusCode);
        } else {
            $this->StatusCode = $statusCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\ETCoupon
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
