<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckinTarget StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CheckinTarget
 * @subpackage Structs
 */
class CheckinTarget extends ApiObject
{
    /**
     * The ETTicketCheckinList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfETTicketCheckin
     */
    public $ETTicketCheckinList;
    /**
     * The OriginDestinationOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OriginDestinationOrder;
    /**
     * The RefItinerary
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefItinerary;
    /**
     * Constructor method for CheckinTarget
     * @uses CheckinTarget::setETTicketCheckinList()
     * @uses CheckinTarget::setOriginDestinationOrder()
     * @uses CheckinTarget::setRefItinerary()
     * @param \App|C\ArrayType\ArrayOfETTicketCheckin $eTTicketCheckinList
     * @param int $originDestinationOrder
     * @param string $refItinerary
     */
    public function __construct(\App|C\ArrayType\ArrayOfETTicketCheckin $eTTicketCheckinList = null, $originDestinationOrder = null, $refItinerary = null)
    {
        $this
            ->setETTicketCheckinList($eTTicketCheckinList)
            ->setOriginDestinationOrder($originDestinationOrder)
            ->setRefItinerary($refItinerary);
    }
    /**
     * Get ETTicketCheckinList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfETTicketCheckin|null
     */
    public function getETTicketCheckinList()
    {
        return isset($this->ETTicketCheckinList) ? $this->ETTicketCheckinList : null;
    }
    /**
     * Set ETTicketCheckinList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfETTicketCheckin $eTTicketCheckinList
     * @return \App|C\StructType\CheckinTarget
     */
    public function setETTicketCheckinList(\App|C\ArrayType\ArrayOfETTicketCheckin $eTTicketCheckinList = null)
    {
        if (is_null($eTTicketCheckinList) || (is_array($eTTicketCheckinList) && empty($eTTicketCheckinList))) {
            unset($this->ETTicketCheckinList);
        } else {
            $this->ETTicketCheckinList = $eTTicketCheckinList;
        }
        return $this;
    }
    /**
     * Get OriginDestinationOrder value
     * @return int|null
     */
    public function getOriginDestinationOrder()
    {
        return $this->OriginDestinationOrder;
    }
    /**
     * Set OriginDestinationOrder value
     * @param int $originDestinationOrder
     * @return \App|C\StructType\CheckinTarget
     */
    public function setOriginDestinationOrder($originDestinationOrder = null)
    {
        // validation for constraint: int
        if (!is_null($originDestinationOrder) && !(is_int($originDestinationOrder) || ctype_digit($originDestinationOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originDestinationOrder, true), gettype($originDestinationOrder)), __LINE__);
        }
        $this->OriginDestinationOrder = $originDestinationOrder;
        return $this;
    }
    /**
     * Get RefItinerary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefItinerary()
    {
        return isset($this->RefItinerary) ? $this->RefItinerary : null;
    }
    /**
     * Set RefItinerary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refItinerary
     * @return \App|C\StructType\CheckinTarget
     */
    public function setRefItinerary($refItinerary = null)
    {
        // validation for constraint: string
        if (!is_null($refItinerary) && !is_string($refItinerary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refItinerary, true), gettype($refItinerary)), __LINE__);
        }
        if (is_null($refItinerary) || (is_array($refItinerary) && empty($refItinerary))) {
            unset($this->RefItinerary);
        } else {
            $this->RefItinerary = $refItinerary;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\CheckinTarget
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
