<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalendarDay StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CalendarDay
 * @subpackage Structs
 */
class CalendarDay extends ApiObject
{
    /**
     * The CalendarDayStatusCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CalendarDayStatusCode;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * Constructor method for CalendarDay
     * @uses CalendarDay::setCalendarDayStatusCode()
     * @uses CalendarDay::setDate()
     * @param string $calendarDayStatusCode
     * @param string $date
     */
    public function __construct($calendarDayStatusCode = null, $date = null)
    {
        $this
            ->setCalendarDayStatusCode($calendarDayStatusCode)
            ->setDate($date);
    }
    /**
     * Get CalendarDayStatusCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalendarDayStatusCode()
    {
        return isset($this->CalendarDayStatusCode) ? $this->CalendarDayStatusCode : null;
    }
    /**
     * Set CalendarDayStatusCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calendarDayStatusCode
     * @return \App|C\StructType\CalendarDay
     */
    public function setCalendarDayStatusCode($calendarDayStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($calendarDayStatusCode) && !is_string($calendarDayStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calendarDayStatusCode, true), gettype($calendarDayStatusCode)), __LINE__);
        }
        if (is_null($calendarDayStatusCode) || (is_array($calendarDayStatusCode) && empty($calendarDayStatusCode))) {
            unset($this->CalendarDayStatusCode);
        } else {
            $this->CalendarDayStatusCode = $calendarDayStatusCode;
        }
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \App|C\StructType\CalendarDay
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\CalendarDay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
