<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RequestInfo
 * @subpackage Structs
 */
class RequestInfo extends ApiObject
{
    /**
     * The AuthenticationKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthenticationKey;
    /**
     * The CultureName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CultureName;
    /**
     * The EchoToken
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EchoToken;
    /**
     * Constructor method for RequestInfo
     * @uses RequestInfo::setAuthenticationKey()
     * @uses RequestInfo::setCultureName()
     * @uses RequestInfo::setEchoToken()
     * @param string $authenticationKey
     * @param string $cultureName
     * @param string $echoToken
     */
    public function __construct($authenticationKey = null, $cultureName = null, $echoToken = null)
    {
        $this
            ->setAuthenticationKey($authenticationKey)
            ->setCultureName($cultureName)
            ->setEchoToken($echoToken);
    }
    /**
     * Get AuthenticationKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthenticationKey()
    {
        return isset($this->AuthenticationKey) ? $this->AuthenticationKey : null;
    }
    /**
     * Set AuthenticationKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authenticationKey
     * @return \App|C\StructType\RequestInfo
     */
    public function setAuthenticationKey($authenticationKey = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationKey) && !is_string($authenticationKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authenticationKey, true), gettype($authenticationKey)), __LINE__);
        }
        if (is_null($authenticationKey) || (is_array($authenticationKey) && empty($authenticationKey))) {
            unset($this->AuthenticationKey);
        } else {
            $this->AuthenticationKey = $authenticationKey;
        }
        return $this;
    }
    /**
     * Get CultureName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCultureName()
    {
        return isset($this->CultureName) ? $this->CultureName : null;
    }
    /**
     * Set CultureName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cultureName
     * @return \App|C\StructType\RequestInfo
     */
    public function setCultureName($cultureName = null)
    {
        // validation for constraint: string
        if (!is_null($cultureName) && !is_string($cultureName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cultureName, true), gettype($cultureName)), __LINE__);
        }
        if (is_null($cultureName) || (is_array($cultureName) && empty($cultureName))) {
            unset($this->CultureName);
        } else {
            $this->CultureName = $cultureName;
        }
        return $this;
    }
    /**
     * Get EchoToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEchoToken()
    {
        return isset($this->EchoToken) ? $this->EchoToken : null;
    }
    /**
     * Set EchoToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $echoToken
     * @return \App|C\StructType\RequestInfo
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($echoToken, true), gettype($echoToken)), __LINE__);
        }
        if (is_null($echoToken) || (is_array($echoToken) && empty($echoToken))) {
            unset($this->EchoToken);
        } else {
            $this->EchoToken = $echoToken;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\RequestInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
