<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IFTIssuanceInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:IFTIssuanceInfo
 * @subpackage Structs
 */
class IFTIssuanceInfo extends ApiObject
{
    /**
     * The RefPointOfSale
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefPointOfSale;
    /**
     * The RefTicketIssuanceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefTicketIssuanceType;
    /**
     * The TravelAgencyAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TravelAgencyAddress;
    /**
     * The TravelAgencyName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TravelAgencyName;
    /**
     * Constructor method for IFTIssuanceInfo
     * @uses IFTIssuanceInfo::setRefPointOfSale()
     * @uses IFTIssuanceInfo::setRefTicketIssuanceType()
     * @uses IFTIssuanceInfo::setTravelAgencyAddress()
     * @uses IFTIssuanceInfo::setTravelAgencyName()
     * @param string $refPointOfSale
     * @param string $refTicketIssuanceType
     * @param string $travelAgencyAddress
     * @param string $travelAgencyName
     */
    public function __construct($refPointOfSale = null, $refTicketIssuanceType = null, $travelAgencyAddress = null, $travelAgencyName = null)
    {
        $this
            ->setRefPointOfSale($refPointOfSale)
            ->setRefTicketIssuanceType($refTicketIssuanceType)
            ->setTravelAgencyAddress($travelAgencyAddress)
            ->setTravelAgencyName($travelAgencyName);
    }
    /**
     * Get RefPointOfSale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefPointOfSale()
    {
        return isset($this->RefPointOfSale) ? $this->RefPointOfSale : null;
    }
    /**
     * Set RefPointOfSale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refPointOfSale
     * @return \App|C\StructType\IFTIssuanceInfo
     */
    public function setRefPointOfSale($refPointOfSale = null)
    {
        // validation for constraint: string
        if (!is_null($refPointOfSale) && !is_string($refPointOfSale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refPointOfSale, true), gettype($refPointOfSale)), __LINE__);
        }
        if (is_null($refPointOfSale) || (is_array($refPointOfSale) && empty($refPointOfSale))) {
            unset($this->RefPointOfSale);
        } else {
            $this->RefPointOfSale = $refPointOfSale;
        }
        return $this;
    }
    /**
     * Get RefTicketIssuanceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefTicketIssuanceType()
    {
        return isset($this->RefTicketIssuanceType) ? $this->RefTicketIssuanceType : null;
    }
    /**
     * Set RefTicketIssuanceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refTicketIssuanceType
     * @return \App|C\StructType\IFTIssuanceInfo
     */
    public function setRefTicketIssuanceType($refTicketIssuanceType = null)
    {
        // validation for constraint: string
        if (!is_null($refTicketIssuanceType) && !is_string($refTicketIssuanceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refTicketIssuanceType, true), gettype($refTicketIssuanceType)), __LINE__);
        }
        if (is_null($refTicketIssuanceType) || (is_array($refTicketIssuanceType) && empty($refTicketIssuanceType))) {
            unset($this->RefTicketIssuanceType);
        } else {
            $this->RefTicketIssuanceType = $refTicketIssuanceType;
        }
        return $this;
    }
    /**
     * Get TravelAgencyAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTravelAgencyAddress()
    {
        return isset($this->TravelAgencyAddress) ? $this->TravelAgencyAddress : null;
    }
    /**
     * Set TravelAgencyAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $travelAgencyAddress
     * @return \App|C\StructType\IFTIssuanceInfo
     */
    public function setTravelAgencyAddress($travelAgencyAddress = null)
    {
        // validation for constraint: string
        if (!is_null($travelAgencyAddress) && !is_string($travelAgencyAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelAgencyAddress, true), gettype($travelAgencyAddress)), __LINE__);
        }
        if (is_null($travelAgencyAddress) || (is_array($travelAgencyAddress) && empty($travelAgencyAddress))) {
            unset($this->TravelAgencyAddress);
        } else {
            $this->TravelAgencyAddress = $travelAgencyAddress;
        }
        return $this;
    }
    /**
     * Get TravelAgencyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTravelAgencyName()
    {
        return isset($this->TravelAgencyName) ? $this->TravelAgencyName : null;
    }
    /**
     * Set TravelAgencyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $travelAgencyName
     * @return \App|C\StructType\IFTIssuanceInfo
     */
    public function setTravelAgencyName($travelAgencyName = null)
    {
        // validation for constraint: string
        if (!is_null($travelAgencyName) && !is_string($travelAgencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelAgencyName, true), gettype($travelAgencyName)), __LINE__);
        }
        if (is_null($travelAgencyName) || (is_array($travelAgencyName) && empty($travelAgencyName))) {
            unset($this->TravelAgencyName);
        } else {
            $this->TravelAgencyName = $travelAgencyName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\IFTIssuanceInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
