<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormOfPaymentConfig StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:FormOfPaymentConfig
 * @subpackage Structs
 */
class FormOfPaymentConfig extends ApiObject
{
    /**
     * The AllowedCurrencyCodes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfstring
     */
    public $AllowedCurrencyCodes;
    /**
     * The FopTemplate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\Fop
     */
    public $FopTemplate;
    /**
     * The FormOfPaymentCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormOfPaymentCode;
    /**
     * The OnlinePaymentInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\OnlinePaymentInfo
     */
    public $OnlinePaymentInfo;
    /**
     * Constructor method for FormOfPaymentConfig
     * @uses FormOfPaymentConfig::setAllowedCurrencyCodes()
     * @uses FormOfPaymentConfig::setFopTemplate()
     * @uses FormOfPaymentConfig::setFormOfPaymentCode()
     * @uses FormOfPaymentConfig::setOnlinePaymentInfo()
     * @param \App|C\ArrayType\ArrayOfstring $allowedCurrencyCodes
     * @param \App|C\StructType\Fop $fopTemplate
     * @param string $formOfPaymentCode
     * @param \App|C\StructType\OnlinePaymentInfo $onlinePaymentInfo
     */
    public function __construct(\App|C\ArrayType\ArrayOfstring $allowedCurrencyCodes = null, \App|C\StructType\Fop $fopTemplate = null, $formOfPaymentCode = null, \App|C\StructType\OnlinePaymentInfo $onlinePaymentInfo = null)
    {
        $this
            ->setAllowedCurrencyCodes($allowedCurrencyCodes)
            ->setFopTemplate($fopTemplate)
            ->setFormOfPaymentCode($formOfPaymentCode)
            ->setOnlinePaymentInfo($onlinePaymentInfo);
    }
    /**
     * Get AllowedCurrencyCodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfstring|null
     */
    public function getAllowedCurrencyCodes()
    {
        return isset($this->AllowedCurrencyCodes) ? $this->AllowedCurrencyCodes : null;
    }
    /**
     * Set AllowedCurrencyCodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfstring $allowedCurrencyCodes
     * @return \App|C\StructType\FormOfPaymentConfig
     */
    public function setAllowedCurrencyCodes(\App|C\ArrayType\ArrayOfstring $allowedCurrencyCodes = null)
    {
        if (is_null($allowedCurrencyCodes) || (is_array($allowedCurrencyCodes) && empty($allowedCurrencyCodes))) {
            unset($this->AllowedCurrencyCodes);
        } else {
            $this->AllowedCurrencyCodes = $allowedCurrencyCodes;
        }
        return $this;
    }
    /**
     * Get FopTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\Fop|null
     */
    public function getFopTemplate()
    {
        return isset($this->FopTemplate) ? $this->FopTemplate : null;
    }
    /**
     * Set FopTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\Fop $fopTemplate
     * @return \App|C\StructType\FormOfPaymentConfig
     */
    public function setFopTemplate(\App|C\StructType\Fop $fopTemplate = null)
    {
        if (is_null($fopTemplate) || (is_array($fopTemplate) && empty($fopTemplate))) {
            unset($this->FopTemplate);
        } else {
            $this->FopTemplate = $fopTemplate;
        }
        return $this;
    }
    /**
     * Get FormOfPaymentCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormOfPaymentCode()
    {
        return isset($this->FormOfPaymentCode) ? $this->FormOfPaymentCode : null;
    }
    /**
     * Set FormOfPaymentCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formOfPaymentCode
     * @return \App|C\StructType\FormOfPaymentConfig
     */
    public function setFormOfPaymentCode($formOfPaymentCode = null)
    {
        // validation for constraint: string
        if (!is_null($formOfPaymentCode) && !is_string($formOfPaymentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formOfPaymentCode, true), gettype($formOfPaymentCode)), __LINE__);
        }
        if (is_null($formOfPaymentCode) || (is_array($formOfPaymentCode) && empty($formOfPaymentCode))) {
            unset($this->FormOfPaymentCode);
        } else {
            $this->FormOfPaymentCode = $formOfPaymentCode;
        }
        return $this;
    }
    /**
     * Get OnlinePaymentInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\OnlinePaymentInfo|null
     */
    public function getOnlinePaymentInfo()
    {
        return isset($this->OnlinePaymentInfo) ? $this->OnlinePaymentInfo : null;
    }
    /**
     * Set OnlinePaymentInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\OnlinePaymentInfo $onlinePaymentInfo
     * @return \App|C\StructType\FormOfPaymentConfig
     */
    public function setOnlinePaymentInfo(\App|C\StructType\OnlinePaymentInfo $onlinePaymentInfo = null)
    {
        if (is_null($onlinePaymentInfo) || (is_array($onlinePaymentInfo) && empty($onlinePaymentInfo))) {
            unset($this->OnlinePaymentInfo);
        } else {
            $this->OnlinePaymentInfo = $onlinePaymentInfo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\FormOfPaymentConfig
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
