<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FaultDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:FaultDetails
 * @subpackage Structs
 */
class FaultDetails extends AbstractStructBase
{
    /**
     * The ExceptionInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\FaultExceptionInfo
     */
    public $ExceptionInfo;
    /**
     * The IdRecord
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IdRecord;
    /**
     * The ReceivedDateGMT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReceivedDateGMT;
    /**
     * The ReplayInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\FaultReplayInfo
     */
    public $ReplayInfo;
    /**
     * Constructor method for FaultDetails
     * @uses FaultDetails::setExceptionInfo()
     * @uses FaultDetails::setIdRecord()
     * @uses FaultDetails::setReceivedDateGMT()
     * @uses FaultDetails::setReplayInfo()
     * @param \App|C\StructType\FaultExceptionInfo $exceptionInfo
     * @param int $idRecord
     * @param string $receivedDateGMT
     * @param \App|C\StructType\FaultReplayInfo $replayInfo
     */
    public function __construct(\App|C\StructType\FaultExceptionInfo $exceptionInfo = null, $idRecord = null, $receivedDateGMT = null, \App|C\StructType\FaultReplayInfo $replayInfo = null)
    {
        $this
            ->setExceptionInfo($exceptionInfo)
            ->setIdRecord($idRecord)
            ->setReceivedDateGMT($receivedDateGMT)
            ->setReplayInfo($replayInfo);
    }
    /**
     * Get ExceptionInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\FaultExceptionInfo|null
     */
    public function getExceptionInfo()
    {
        return isset($this->ExceptionInfo) ? $this->ExceptionInfo : null;
    }
    /**
     * Set ExceptionInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\FaultExceptionInfo $exceptionInfo
     * @return \App|C\StructType\FaultDetails
     */
    public function setExceptionInfo(\App|C\StructType\FaultExceptionInfo $exceptionInfo = null)
    {
        if (is_null($exceptionInfo) || (is_array($exceptionInfo) && empty($exceptionInfo))) {
            unset($this->ExceptionInfo);
        } else {
            $this->ExceptionInfo = $exceptionInfo;
        }
        return $this;
    }
    /**
     * Get IdRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdRecord()
    {
        return isset($this->IdRecord) ? $this->IdRecord : null;
    }
    /**
     * Set IdRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idRecord
     * @return \App|C\StructType\FaultDetails
     */
    public function setIdRecord($idRecord = null)
    {
        // validation for constraint: int
        if (!is_null($idRecord) && !(is_int($idRecord) || ctype_digit($idRecord))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idRecord, true), gettype($idRecord)), __LINE__);
        }
        if (is_null($idRecord) || (is_array($idRecord) && empty($idRecord))) {
            unset($this->IdRecord);
        } else {
            $this->IdRecord = $idRecord;
        }
        return $this;
    }
    /**
     * Get ReceivedDateGMT value
     * @return string|null
     */
    public function getReceivedDateGMT()
    {
        return $this->ReceivedDateGMT;
    }
    /**
     * Set ReceivedDateGMT value
     * @param string $receivedDateGMT
     * @return \App|C\StructType\FaultDetails
     */
    public function setReceivedDateGMT($receivedDateGMT = null)
    {
        // validation for constraint: string
        if (!is_null($receivedDateGMT) && !is_string($receivedDateGMT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receivedDateGMT, true), gettype($receivedDateGMT)), __LINE__);
        }
        $this->ReceivedDateGMT = $receivedDateGMT;
        return $this;
    }
    /**
     * Get ReplayInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\FaultReplayInfo|null
     */
    public function getReplayInfo()
    {
        return isset($this->ReplayInfo) ? $this->ReplayInfo : null;
    }
    /**
     * Set ReplayInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\FaultReplayInfo $replayInfo
     * @return \App|C\StructType\FaultDetails
     */
    public function setReplayInfo(\App|C\StructType\FaultReplayInfo $replayInfo = null)
    {
        if (is_null($replayInfo) || (is_array($replayInfo) && empty($replayInfo))) {
            unset($this->ReplayInfo);
        } else {
            $this->ReplayInfo = $replayInfo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\FaultDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
