<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ETCouponFare StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ETCouponFare
 * @subpackage Structs
 */
class ETCouponFare extends AbstractFareOfAmountDetails48VTEFp2
{
    /**
     * The BagAllowances
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfBagAllowance
     */
    public $BagAllowances;
    /**
     * The BookingClassCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingClassCode;
    /**
     * The CouponOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CouponOrder;
    /**
     * The FareBasisCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FareBasisCode;
    /**
     * The RefSegment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefSegment;
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfCouponTax
     */
    public $Taxes;
    /**
     * Constructor method for ETCouponFare
     * @uses ETCouponFare::setBagAllowances()
     * @uses ETCouponFare::setBookingClassCode()
     * @uses ETCouponFare::setCouponOrder()
     * @uses ETCouponFare::setFareBasisCode()
     * @uses ETCouponFare::setRefSegment()
     * @uses ETCouponFare::setTaxes()
     * @param \App|C\ArrayType\ArrayOfBagAllowance $bagAllowances
     * @param string $bookingClassCode
     * @param int $couponOrder
     * @param string $fareBasisCode
     * @param string $refSegment
     * @param \App|C\ArrayType\ArrayOfCouponTax $taxes
     */
    public function __construct(\App|C\ArrayType\ArrayOfBagAllowance $bagAllowances = null, $bookingClassCode = null, $couponOrder = null, $fareBasisCode = null, $refSegment = null, \App|C\ArrayType\ArrayOfCouponTax $taxes = null)
    {
        $this
            ->setBagAllowances($bagAllowances)
            ->setBookingClassCode($bookingClassCode)
            ->setCouponOrder($couponOrder)
            ->setFareBasisCode($fareBasisCode)
            ->setRefSegment($refSegment)
            ->setTaxes($taxes);
    }
    /**
     * Get BagAllowances value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfBagAllowance|null
     */
    public function getBagAllowances()
    {
        return isset($this->BagAllowances) ? $this->BagAllowances : null;
    }
    /**
     * Set BagAllowances value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfBagAllowance $bagAllowances
     * @return \App|C\StructType\ETCouponFare
     */
    public function setBagAllowances(\App|C\ArrayType\ArrayOfBagAllowance $bagAllowances = null)
    {
        if (is_null($bagAllowances) || (is_array($bagAllowances) && empty($bagAllowances))) {
            unset($this->BagAllowances);
        } else {
            $this->BagAllowances = $bagAllowances;
        }
        return $this;
    }
    /**
     * Get BookingClassCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingClassCode()
    {
        return isset($this->BookingClassCode) ? $this->BookingClassCode : null;
    }
    /**
     * Set BookingClassCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingClassCode
     * @return \App|C\StructType\ETCouponFare
     */
    public function setBookingClassCode($bookingClassCode = null)
    {
        // validation for constraint: string
        if (!is_null($bookingClassCode) && !is_string($bookingClassCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingClassCode, true), gettype($bookingClassCode)), __LINE__);
        }
        if (is_null($bookingClassCode) || (is_array($bookingClassCode) && empty($bookingClassCode))) {
            unset($this->BookingClassCode);
        } else {
            $this->BookingClassCode = $bookingClassCode;
        }
        return $this;
    }
    /**
     * Get CouponOrder value
     * @return int|null
     */
    public function getCouponOrder()
    {
        return $this->CouponOrder;
    }
    /**
     * Set CouponOrder value
     * @param int $couponOrder
     * @return \App|C\StructType\ETCouponFare
     */
    public function setCouponOrder($couponOrder = null)
    {
        // validation for constraint: int
        if (!is_null($couponOrder) && !(is_int($couponOrder) || ctype_digit($couponOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($couponOrder, true), gettype($couponOrder)), __LINE__);
        }
        $this->CouponOrder = $couponOrder;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return isset($this->FareBasisCode) ? $this->FareBasisCode : null;
    }
    /**
     * Set FareBasisCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fareBasisCode
     * @return \App|C\StructType\ETCouponFare
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        if (is_null($fareBasisCode) || (is_array($fareBasisCode) && empty($fareBasisCode))) {
            unset($this->FareBasisCode);
        } else {
            $this->FareBasisCode = $fareBasisCode;
        }
        return $this;
    }
    /**
     * Get RefSegment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefSegment()
    {
        return isset($this->RefSegment) ? $this->RefSegment : null;
    }
    /**
     * Set RefSegment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refSegment
     * @return \App|C\StructType\ETCouponFare
     */
    public function setRefSegment($refSegment = null)
    {
        // validation for constraint: string
        if (!is_null($refSegment) && !is_string($refSegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refSegment, true), gettype($refSegment)), __LINE__);
        }
        if (is_null($refSegment) || (is_array($refSegment) && empty($refSegment))) {
            unset($this->RefSegment);
        } else {
            $this->RefSegment = $refSegment;
        }
        return $this;
    }
    /**
     * Get Taxes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfCouponTax|null
     */
    public function getTaxes()
    {
        return isset($this->Taxes) ? $this->Taxes : null;
    }
    /**
     * Set Taxes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfCouponTax $taxes
     * @return \App|C\StructType\ETCouponFare
     */
    public function setTaxes(\App|C\ArrayType\ArrayOfCouponTax $taxes = null)
    {
        if (is_null($taxes) || (is_array($taxes) && empty($taxes))) {
            unset($this->Taxes);
        } else {
            $this->Taxes = $taxes;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\ETCouponFare
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
