<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ETCouponCheckin StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ETCouponCheckin
 * @subpackage Structs
 */
class ETCouponCheckin extends ApiObject
{
    /**
     * The CheckinStatusCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CheckinStatusCode;
    /**
     * The CouponOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CouponOrder;
    /**
     * The NotAuthorizedReason
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotAuthorizedReason;
    /**
     * Constructor method for ETCouponCheckin
     * @uses ETCouponCheckin::setCheckinStatusCode()
     * @uses ETCouponCheckin::setCouponOrder()
     * @uses ETCouponCheckin::setNotAuthorizedReason()
     * @param string $checkinStatusCode
     * @param int $couponOrder
     * @param string $notAuthorizedReason
     */
    public function __construct($checkinStatusCode = null, $couponOrder = null, $notAuthorizedReason = null)
    {
        $this
            ->setCheckinStatusCode($checkinStatusCode)
            ->setCouponOrder($couponOrder)
            ->setNotAuthorizedReason($notAuthorizedReason);
    }
    /**
     * Get CheckinStatusCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCheckinStatusCode()
    {
        return isset($this->CheckinStatusCode) ? $this->CheckinStatusCode : null;
    }
    /**
     * Set CheckinStatusCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $checkinStatusCode
     * @return \App|C\StructType\ETCouponCheckin
     */
    public function setCheckinStatusCode($checkinStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($checkinStatusCode) && !is_string($checkinStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkinStatusCode, true), gettype($checkinStatusCode)), __LINE__);
        }
        if (is_null($checkinStatusCode) || (is_array($checkinStatusCode) && empty($checkinStatusCode))) {
            unset($this->CheckinStatusCode);
        } else {
            $this->CheckinStatusCode = $checkinStatusCode;
        }
        return $this;
    }
    /**
     * Get CouponOrder value
     * @return int|null
     */
    public function getCouponOrder()
    {
        return $this->CouponOrder;
    }
    /**
     * Set CouponOrder value
     * @param int $couponOrder
     * @return \App|C\StructType\ETCouponCheckin
     */
    public function setCouponOrder($couponOrder = null)
    {
        // validation for constraint: int
        if (!is_null($couponOrder) && !(is_int($couponOrder) || ctype_digit($couponOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($couponOrder, true), gettype($couponOrder)), __LINE__);
        }
        $this->CouponOrder = $couponOrder;
        return $this;
    }
    /**
     * Get NotAuthorizedReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotAuthorizedReason()
    {
        return isset($this->NotAuthorizedReason) ? $this->NotAuthorizedReason : null;
    }
    /**
     * Set NotAuthorizedReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notAuthorizedReason
     * @return \App|C\StructType\ETCouponCheckin
     */
    public function setNotAuthorizedReason($notAuthorizedReason = null)
    {
        // validation for constraint: string
        if (!is_null($notAuthorizedReason) && !is_string($notAuthorizedReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notAuthorizedReason, true), gettype($notAuthorizedReason)), __LINE__);
        }
        if (is_null($notAuthorizedReason) || (is_array($notAuthorizedReason) && empty($notAuthorizedReason))) {
            unset($this->NotAuthorizedReason);
        } else {
            $this->NotAuthorizedReason = $notAuthorizedReason;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\ETCouponCheckin
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
