<?php

namespace App|C\EnumType;

/**
 * This class stands for ExpectationLevel EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ExpectationLevel
 * @subpackage Enumerations
 */
class ExpectationLevel
{
    /**
     * Constant for value 'NotExpected'
     * @return string 'NotExpected'
     */
    const VALUE_NOT_EXPECTED = 'NotExpected';
    /**
     * Constant for value 'Expected'
     * @return string 'Expected'
     */
    const VALUE_EXPECTED = 'Expected';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_EXPECTED
     * @uses self::VALUE_EXPECTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_EXPECTED,
            self::VALUE_EXPECTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
