<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartnerInformation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PartnerInformation
 * @subpackage Structs
 */
class PartnerInformation extends AbstractStructBase
{
    /**
     * The HasPartners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasPartners;
    /**
     * The AllowNameElementChange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowNameElementChange;
    /**
     * Constructor method for PartnerInformation
     * @uses PartnerInformation::setHasPartners()
     * @uses PartnerInformation::setAllowNameElementChange()
     * @param bool $hasPartners
     * @param bool $allowNameElementChange
     */
    public function __construct($hasPartners = null, $allowNameElementChange = null)
    {
        $this
            ->setHasPartners($hasPartners)
            ->setAllowNameElementChange($allowNameElementChange);
    }
    /**
     * Get HasPartners value
     * @return bool|null
     */
    public function getHasPartners()
    {
        return $this->HasPartners;
    }
    /**
     * Set HasPartners value
     * @param bool $hasPartners
     * @return \App|C\StructType\PartnerInformation
     */
    public function setHasPartners($hasPartners = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasPartners) && !is_bool($hasPartners)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasPartners, true), gettype($hasPartners)), __LINE__);
        }
        $this->HasPartners = $hasPartners;
        return $this;
    }
    /**
     * Get AllowNameElementChange value
     * @return bool|null
     */
    public function getAllowNameElementChange()
    {
        return $this->AllowNameElementChange;
    }
    /**
     * Set AllowNameElementChange value
     * @param bool $allowNameElementChange
     * @return \App|C\StructType\PartnerInformation
     */
    public function setAllowNameElementChange($allowNameElementChange = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowNameElementChange) && !is_bool($allowNameElementChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowNameElementChange, true), gettype($allowNameElementChange)), __LINE__);
        }
        $this->AllowNameElementChange = $allowNameElementChange;
        return $this;
    }
}
