<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingSummary StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BookingSummary
 * @subpackage Structs
 */
class BookingSummary extends ApiObject
{
    /**
     * The IsFutureFlight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsFutureFlight;
    /**
     * The NextActiveAirportCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NextActiveAirportCode;
    /**
     * The NextActiveDepartureDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NextActiveDepartureDate;
    /**
     * The NextInactiveAirportCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NextInactiveAirportCode;
    /**
     * The NextInactiveDepartureDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NextInactiveDepartureDate;
    /**
     * The PnrCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PnrCode;
    /**
     * The PnrStatusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PnrStatusCode;
    /**
     * The TimeLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TimeLimit;
    /**
     * The NextActiveArrivalAirportCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NextActiveArrivalAirportCode;
    /**
     * The NextActiveFlightDuration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NextActiveFlightDuration;
    /**
     * Constructor method for BookingSummary
     * @uses BookingSummary::setIsFutureFlight()
     * @uses BookingSummary::setNextActiveAirportCode()
     * @uses BookingSummary::setNextActiveDepartureDate()
     * @uses BookingSummary::setNextInactiveAirportCode()
     * @uses BookingSummary::setNextInactiveDepartureDate()
     * @uses BookingSummary::setPnrCode()
     * @uses BookingSummary::setPnrStatusCode()
     * @uses BookingSummary::setTimeLimit()
     * @uses BookingSummary::setNextActiveArrivalAirportCode()
     * @uses BookingSummary::setNextActiveFlightDuration()
     * @param bool $isFutureFlight
     * @param string $nextActiveAirportCode
     * @param string $nextActiveDepartureDate
     * @param string $nextInactiveAirportCode
     * @param string $nextInactiveDepartureDate
     * @param string $pnrCode
     * @param string $pnrStatusCode
     * @param string $timeLimit
     * @param string $nextActiveArrivalAirportCode
     * @param int $nextActiveFlightDuration
     */
    public function __construct($isFutureFlight = null, $nextActiveAirportCode = null, $nextActiveDepartureDate = null, $nextInactiveAirportCode = null, $nextInactiveDepartureDate = null, $pnrCode = null, $pnrStatusCode = null, $timeLimit = null, $nextActiveArrivalAirportCode = null, $nextActiveFlightDuration = null)
    {
        $this
            ->setIsFutureFlight($isFutureFlight)
            ->setNextActiveAirportCode($nextActiveAirportCode)
            ->setNextActiveDepartureDate($nextActiveDepartureDate)
            ->setNextInactiveAirportCode($nextInactiveAirportCode)
            ->setNextInactiveDepartureDate($nextInactiveDepartureDate)
            ->setPnrCode($pnrCode)
            ->setPnrStatusCode($pnrStatusCode)
            ->setTimeLimit($timeLimit)
            ->setNextActiveArrivalAirportCode($nextActiveArrivalAirportCode)
            ->setNextActiveFlightDuration($nextActiveFlightDuration);
    }
    /**
     * Get IsFutureFlight value
     * @return bool|null
     */
    public function getIsFutureFlight()
    {
        return $this->IsFutureFlight;
    }
    /**
     * Set IsFutureFlight value
     * @param bool $isFutureFlight
     * @return \App|C\StructType\BookingSummary
     */
    public function setIsFutureFlight($isFutureFlight = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFutureFlight) && !is_bool($isFutureFlight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFutureFlight, true), gettype($isFutureFlight)), __LINE__);
        }
        $this->IsFutureFlight = $isFutureFlight;
        return $this;
    }
    /**
     * Get NextActiveAirportCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNextActiveAirportCode()
    {
        return isset($this->NextActiveAirportCode) ? $this->NextActiveAirportCode : null;
    }
    /**
     * Set NextActiveAirportCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nextActiveAirportCode
     * @return \App|C\StructType\BookingSummary
     */
    public function setNextActiveAirportCode($nextActiveAirportCode = null)
    {
        // validation for constraint: string
        if (!is_null($nextActiveAirportCode) && !is_string($nextActiveAirportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextActiveAirportCode, true), gettype($nextActiveAirportCode)), __LINE__);
        }
        if (is_null($nextActiveAirportCode) || (is_array($nextActiveAirportCode) && empty($nextActiveAirportCode))) {
            unset($this->NextActiveAirportCode);
        } else {
            $this->NextActiveAirportCode = $nextActiveAirportCode;
        }
        return $this;
    }
    /**
     * Get NextActiveDepartureDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNextActiveDepartureDate()
    {
        return isset($this->NextActiveDepartureDate) ? $this->NextActiveDepartureDate : null;
    }
    /**
     * Set NextActiveDepartureDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nextActiveDepartureDate
     * @return \App|C\StructType\BookingSummary
     */
    public function setNextActiveDepartureDate($nextActiveDepartureDate = null)
    {
        // validation for constraint: string
        if (!is_null($nextActiveDepartureDate) && !is_string($nextActiveDepartureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextActiveDepartureDate, true), gettype($nextActiveDepartureDate)), __LINE__);
        }
        if (is_null($nextActiveDepartureDate) || (is_array($nextActiveDepartureDate) && empty($nextActiveDepartureDate))) {
            unset($this->NextActiveDepartureDate);
        } else {
            $this->NextActiveDepartureDate = $nextActiveDepartureDate;
        }
        return $this;
    }
    /**
     * Get NextInactiveAirportCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNextInactiveAirportCode()
    {
        return isset($this->NextInactiveAirportCode) ? $this->NextInactiveAirportCode : null;
    }
    /**
     * Set NextInactiveAirportCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nextInactiveAirportCode
     * @return \App|C\StructType\BookingSummary
     */
    public function setNextInactiveAirportCode($nextInactiveAirportCode = null)
    {
        // validation for constraint: string
        if (!is_null($nextInactiveAirportCode) && !is_string($nextInactiveAirportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextInactiveAirportCode, true), gettype($nextInactiveAirportCode)), __LINE__);
        }
        if (is_null($nextInactiveAirportCode) || (is_array($nextInactiveAirportCode) && empty($nextInactiveAirportCode))) {
            unset($this->NextInactiveAirportCode);
        } else {
            $this->NextInactiveAirportCode = $nextInactiveAirportCode;
        }
        return $this;
    }
    /**
     * Get NextInactiveDepartureDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNextInactiveDepartureDate()
    {
        return isset($this->NextInactiveDepartureDate) ? $this->NextInactiveDepartureDate : null;
    }
    /**
     * Set NextInactiveDepartureDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nextInactiveDepartureDate
     * @return \App|C\StructType\BookingSummary
     */
    public function setNextInactiveDepartureDate($nextInactiveDepartureDate = null)
    {
        // validation for constraint: string
        if (!is_null($nextInactiveDepartureDate) && !is_string($nextInactiveDepartureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextInactiveDepartureDate, true), gettype($nextInactiveDepartureDate)), __LINE__);
        }
        if (is_null($nextInactiveDepartureDate) || (is_array($nextInactiveDepartureDate) && empty($nextInactiveDepartureDate))) {
            unset($this->NextInactiveDepartureDate);
        } else {
            $this->NextInactiveDepartureDate = $nextInactiveDepartureDate;
        }
        return $this;
    }
    /**
     * Get PnrCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPnrCode()
    {
        return isset($this->PnrCode) ? $this->PnrCode : null;
    }
    /**
     * Set PnrCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pnrCode
     * @return \App|C\StructType\BookingSummary
     */
    public function setPnrCode($pnrCode = null)
    {
        // validation for constraint: string
        if (!is_null($pnrCode) && !is_string($pnrCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pnrCode, true), gettype($pnrCode)), __LINE__);
        }
        if (is_null($pnrCode) || (is_array($pnrCode) && empty($pnrCode))) {
            unset($this->PnrCode);
        } else {
            $this->PnrCode = $pnrCode;
        }
        return $this;
    }
    /**
     * Get PnrStatusCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPnrStatusCode()
    {
        return isset($this->PnrStatusCode) ? $this->PnrStatusCode : null;
    }
    /**
     * Set PnrStatusCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pnrStatusCode
     * @return \App|C\StructType\BookingSummary
     */
    public function setPnrStatusCode($pnrStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($pnrStatusCode) && !is_string($pnrStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pnrStatusCode, true), gettype($pnrStatusCode)), __LINE__);
        }
        if (is_null($pnrStatusCode) || (is_array($pnrStatusCode) && empty($pnrStatusCode))) {
            unset($this->PnrStatusCode);
        } else {
            $this->PnrStatusCode = $pnrStatusCode;
        }
        return $this;
    }
    /**
     * Get TimeLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeLimit()
    {
        return isset($this->TimeLimit) ? $this->TimeLimit : null;
    }
    /**
     * Set TimeLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeLimit
     * @return \App|C\StructType\BookingSummary
     */
    public function setTimeLimit($timeLimit = null)
    {
        // validation for constraint: string
        if (!is_null($timeLimit) && !is_string($timeLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeLimit, true), gettype($timeLimit)), __LINE__);
        }
        if (is_null($timeLimit) || (is_array($timeLimit) && empty($timeLimit))) {
            unset($this->TimeLimit);
        } else {
            $this->TimeLimit = $timeLimit;
        }
        return $this;
    }
    /**
     * Get NextActiveArrivalAirportCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNextActiveArrivalAirportCode()
    {
        return isset($this->NextActiveArrivalAirportCode) ? $this->NextActiveArrivalAirportCode : null;
    }
    /**
     * Set NextActiveArrivalAirportCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nextActiveArrivalAirportCode
     * @return \App|C\StructType\BookingSummary
     */
    public function setNextActiveArrivalAirportCode($nextActiveArrivalAirportCode = null)
    {
        // validation for constraint: string
        if (!is_null($nextActiveArrivalAirportCode) && !is_string($nextActiveArrivalAirportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextActiveArrivalAirportCode, true), gettype($nextActiveArrivalAirportCode)), __LINE__);
        }
        if (is_null($nextActiveArrivalAirportCode) || (is_array($nextActiveArrivalAirportCode) && empty($nextActiveArrivalAirportCode))) {
            unset($this->NextActiveArrivalAirportCode);
        } else {
            $this->NextActiveArrivalAirportCode = $nextActiveArrivalAirportCode;
        }
        return $this;
    }
    /**
     * Get NextActiveFlightDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNextActiveFlightDuration()
    {
        return isset($this->NextActiveFlightDuration) ? $this->NextActiveFlightDuration : null;
    }
    /**
     * Set NextActiveFlightDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $nextActiveFlightDuration
     * @return \App|C\StructType\BookingSummary
     */
    public function setNextActiveFlightDuration($nextActiveFlightDuration = null)
    {
        // validation for constraint: int
        if (!is_null($nextActiveFlightDuration) && !(is_int($nextActiveFlightDuration) || ctype_digit($nextActiveFlightDuration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nextActiveFlightDuration, true), gettype($nextActiveFlightDuration)), __LINE__);
        }
        if (is_null($nextActiveFlightDuration) || (is_array($nextActiveFlightDuration) && empty($nextActiveFlightDuration))) {
            unset($this->NextActiveFlightDuration);
        } else {
            $this->NextActiveFlightDuration = $nextActiveFlightDuration;
        }
        return $this;
    }
}
