<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EMDSubCode StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EMDSubCode
 * @subpackage Structs
 */
class EMDSubCode extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The GroupCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GroupCode;
    /**
     * The RFIC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RFIC;
    /**
     * Constructor method for EMDSubCode
     * @uses EMDSubCode::setCode()
     * @uses EMDSubCode::setGroupCode()
     * @uses EMDSubCode::setRFIC()
     * @param string $code
     * @param string $groupCode
     * @param string $rFIC
     */
    public function __construct($code = null, $groupCode = null, $rFIC = null)
    {
        $this
            ->setCode($code)
            ->setGroupCode($groupCode)
            ->setRFIC($rFIC);
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \App|C\StructType\EMDSubCode
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get GroupCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupCode()
    {
        return isset($this->GroupCode) ? $this->GroupCode : null;
    }
    /**
     * Set GroupCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupCode
     * @return \App|C\StructType\EMDSubCode
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupCode) && !is_string($groupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupCode, true), gettype($groupCode)), __LINE__);
        }
        if (is_null($groupCode) || (is_array($groupCode) && empty($groupCode))) {
            unset($this->GroupCode);
        } else {
            $this->GroupCode = $groupCode;
        }
        return $this;
    }
    /**
     * Get RFIC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRFIC()
    {
        return isset($this->RFIC) ? $this->RFIC : null;
    }
    /**
     * Set RFIC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rFIC
     * @return \App|C\StructType\EMDSubCode
     */
    public function setRFIC($rFIC = null)
    {
        // validation for constraint: string
        if (!is_null($rFIC) && !is_string($rFIC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFIC, true), gettype($rFIC)), __LINE__);
        }
        if (is_null($rFIC) || (is_array($rFIC) && empty($rFIC))) {
            unset($this->RFIC);
        } else {
            $this->RFIC = $rFIC;
        }
        return $this;
    }
}
