<?php

namespace App|C\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Exchange ServiceType
 * @subpackage Services
 */
class Exchange extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Exchange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\Exchange $parameters
     * @return \App|C\StructType\ExchangeResponse|bool
     */
    public function Exchange(\App|C\StructType\Exchange $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Exchange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App|C\StructType\ExchangeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
