<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketInfo
 * @subpackage Structs
 */
class TicketInfo extends ApiObject
{
    /**
     * The EMDTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfEMDTicket
     */
    public $EMDTickets;
    /**
     * The ETTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfETTicket
     */
    public $ETTickets;
    /**
     * The Fops
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfFop
     */
    public $Fops;
    /**
     * Constructor method for TicketInfo
     * @uses TicketInfo::setEMDTickets()
     * @uses TicketInfo::setETTickets()
     * @uses TicketInfo::setFops()
     * @param \App|C\ArrayType\ArrayOfEMDTicket $eMDTickets
     * @param \App|C\ArrayType\ArrayOfETTicket $eTTickets
     * @param \App|C\ArrayType\ArrayOfFop $fops
     */
    public function __construct(\App|C\ArrayType\ArrayOfEMDTicket $eMDTickets = null, \App|C\ArrayType\ArrayOfETTicket $eTTickets = null, \App|C\ArrayType\ArrayOfFop $fops = null)
    {
        $this
            ->setEMDTickets($eMDTickets)
            ->setETTickets($eTTickets)
            ->setFops($fops);
    }
    /**
     * Get EMDTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfEMDTicket|null
     */
    public function getEMDTickets()
    {
        return isset($this->EMDTickets) ? $this->EMDTickets : null;
    }
    /**
     * Set EMDTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfEMDTicket $eMDTickets
     * @return \App|C\StructType\TicketInfo
     */
    public function setEMDTickets(\App|C\ArrayType\ArrayOfEMDTicket $eMDTickets = null)
    {
        if (is_null($eMDTickets) || (is_array($eMDTickets) && empty($eMDTickets))) {
            unset($this->EMDTickets);
        } else {
            $this->EMDTickets = $eMDTickets;
        }
        return $this;
    }
    /**
     * Get ETTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfETTicket|null
     */
    public function getETTickets()
    {
        return isset($this->ETTickets) ? $this->ETTickets : null;
    }
    /**
     * Set ETTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfETTicket $eTTickets
     * @return \App|C\StructType\TicketInfo
     */
    public function setETTickets(\App|C\ArrayType\ArrayOfETTicket $eTTickets = null)
    {
        if (is_null($eTTickets) || (is_array($eTTickets) && empty($eTTickets))) {
            unset($this->ETTickets);
        } else {
            $this->ETTickets = $eTTickets;
        }
        return $this;
    }
    /**
     * Get Fops value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfFop|null
     */
    public function getFops()
    {
        return isset($this->Fops) ? $this->Fops : null;
    }
    /**
     * Set Fops value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfFop $fops
     * @return \App|C\StructType\TicketInfo
     */
    public function setFops(\App|C\ArrayType\ArrayOfFop $fops = null)
    {
        if (is_null($fops) || (is_array($fops) && empty($fops))) {
            unset($this->Fops);
        } else {
            $this->Fops = $fops;
        }
        return $this;
    }
}
